//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: Jun 12, 2007
//---------------------

package org.cleversafe.config;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.cleversafe.config.exceptions.MethodInvocationException;

// This class allows calls through reflection on execution context 
public class ExecutionContext
{
   private final Map<String, Object> context = new HashMap<String, Object>();

   /**
    * Adds a named object to the context
    * 
    * @param name
    *           of the object
    * @param obj
    *           Object itself
    */
   public void add(final String name, final Object obj)
   {
      assert obj != null;
      this.context.put(name, obj);
   }

   public Map<String, Object> get()
   {
      return Collections.unmodifiableMap(this.context);
   }

   public boolean contains(final String key)
   {
      return this.context.containsKey(key);
   }

   public Object get(final String key)
   {
      return this.context.get(key);
   }

   Object getValue(final String name, final String methodName, final Object... params)
         throws MethodInvocationException
   {
      final Object obj = get(name);
      if (obj == null)
      {
         throw new MethodInvocationException("Object " + name
               + " not found; Could not invoke method '" + methodName + "' on it.");
      }
      final Class<?>[] paramsTypes = new Class<?>[params.length];
      for (int i = 0; i < params.length; i++)
      {
         paramsTypes[i] = params[i].getClass();
      }
      Method method = null;
      try
      {
         method = obj.getClass().getMethod(methodName, paramsTypes);
         return method.invoke(obj, params);
      }
      catch (final Exception e)
      {
         throw new MethodInvocationException("Failed to invoke method '" + methodName + "' on "
               + name, e);
      }
   }
}
