//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: jquigley
//
// Date: Jun 12, 2007
//---------------------

package org.cleversafe.codec.integrity;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;

import org.cleversafe.codec.Encoder;
import org.cleversafe.codec.exceptions.CodecEncodeException;
import org.cleversafe.codec.exceptions.CodecInvalidDataFormatException;
import org.cleversafe.codec.exceptions.CodecInvalidParametersException;
import org.cleversafe.codec.exceptions.CodecNotInitializedException;
import org.cleversafe.layer.grid.SourceName;

public class CRCIntegrityEncoder implements Encoder
{
   private CRC32 crc32;

   public void reset(SourceName sourceName, long transactionId) throws CodecInvalidParametersException
   {
      crc32 = new CRC32();
   }

   public boolean isInitialized()
   {
      return crc32 != null;
   }

   public byte[] process(byte[] data) throws CodecEncodeException, CodecInvalidDataFormatException,
         CodecNotInitializedException
   {
      crc32.update(data);
      return data;
   }

   public byte[] finish() throws CodecEncodeException, CodecInvalidDataFormatException,
         CodecNotInitializedException
   {
      ByteArrayOutputStream bos = new ByteArrayOutputStream();
      DataOutputStream out = new DataOutputStream(bos);

      try
      {
         out.writeInt((int) crc32.getValue());
         out.close();
      } catch ( IOException ex )
      {
         throw new RuntimeException( "I/O error", ex );
      }
      
      return bos.toByteArray();
   }

   public byte[] finish(byte[] data) throws CodecEncodeException, CodecInvalidDataFormatException,
         CodecNotInitializedException
   {
      crc32.update(data);

      ByteArrayOutputStream bos = new ByteArrayOutputStream();
      DataOutputStream out = new DataOutputStream(bos);

      try
      {
         out.write(data);
         out.writeInt((int) crc32.getValue());
         out.close();
      } catch ( IOException ex )
      {
         throw new RuntimeException( "I/O error", ex );
      }

      return bos.toByteArray();
   }

}
