//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
// -----------------------
// Author: Dusty Hendrickson
//
// Date: Jun 5, 2008
// ---------------------

package org.cleversafe.codec.header.zero;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import org.cleversafe.codec.Encoder;
import org.cleversafe.codec.exceptions.CodecEncodeException;
import org.cleversafe.codec.exceptions.CodecInvalidDataFormatException;
import org.cleversafe.codec.exceptions.CodecInvalidParametersException;
import org.cleversafe.codec.exceptions.CodecNotInitializedException;
import org.cleversafe.layer.grid.SourceName;

public class ZeroHeaderEncoder implements Encoder
{
   boolean isEncoded = false;

   public void reset(final SourceName sourceName, final long transactionId)
         throws CodecInvalidParametersException
   {
      this.isEncoded = false;
   }

   public boolean isInitialized()
   {
      return true;
   }

   public byte[] process(final byte[] data) throws CodecEncodeException,
         CodecInvalidDataFormatException, CodecNotInitializedException
   {
      if (!this.isEncoded)
      {
         final ByteArrayOutputStream byteStream = new ByteArrayOutputStream();

         try
         {
            byteStream.write(finish());
            byteStream.write(data);
         }
         catch (final IOException ex)
         {
            throw new RuntimeException("Unable to encode header", ex);
         }

         this.isEncoded = true;

         return byteStream.toByteArray();
      }
      return data;
   }

   public byte[] finish() throws CodecEncodeException, CodecInvalidDataFormatException,
         CodecNotInitializedException
   {
      if (!this.isEncoded)
      {
         this.isEncoded = true;
         return ZeroHeaderCodec.HEADER;
      }
      return new byte[0];
   }

   public byte[] finish(final byte[] data) throws CodecEncodeException,
         CodecInvalidDataFormatException, CodecNotInitializedException
   {
      return process(data);
   }

}
