//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
// -----------------------
// Author: Dusty Hendrickson
//
// Date: Jun 5, 2008
// ---------------------

package org.cleversafe.codec.header.zero;

import java.io.ByteArrayOutputStream;

import org.cleversafe.codec.Decoder;
import org.cleversafe.codec.exceptions.CodecDecodeException;
import org.cleversafe.codec.exceptions.CodecInvalidDataFormatException;
import org.cleversafe.codec.exceptions.CodecInvalidParametersException;
import org.cleversafe.codec.exceptions.CodecNotInitializedException;
import org.cleversafe.layer.grid.SourceName;

public class ZeroHeaderDecoder implements Decoder
{
   boolean isDecoded = false;

   public void reset(final SourceName sourceName, final long transactionId)
         throws CodecInvalidParametersException
   {
      this.isDecoded = false;
   }

   public boolean isInitialized()
   {
      return true;
   }

   public byte[] process(final byte[] data) throws CodecDecodeException,
         CodecInvalidDataFormatException, CodecNotInitializedException
   {
      if (!this.isDecoded)
      {
         final ByteArrayOutputStream byteStream = new ByteArrayOutputStream();

         if (data.length < ZeroHeaderCodec.HEADER.length)
         {
            throw new CodecInvalidDataFormatException("Not enough data to decode: received "
                  + data.length + " byte(s), expected " + ZeroHeaderCodec.HEADER.length
                  + " byte(s)");
         }

         for (int a = 0; a < ZeroHeaderCodec.HEADER.length; a++)
         {
            if (data[a] != ZeroHeaderCodec.HEADER[a])
            {
               throw new CodecInvalidDataFormatException(
                     "Data does not contain expected header: received " + data[0] + " at index "
                           + a + ", expected " + ZeroHeaderCodec.HEADER[a]);
            }
         }

         byteStream.write(data, ZeroHeaderCodec.HEADER_LENGTH, data.length
               - ZeroHeaderCodec.HEADER_LENGTH);

         this.isDecoded = true;

         return byteStream.toByteArray();
      }
      return data;
   }

   public byte[] finish() throws CodecDecodeException, CodecInvalidDataFormatException,
         CodecNotInitializedException
   {
      return new byte[0];
   }

   public byte[] finish(final byte[] data) throws CodecDecodeException,
         CodecInvalidDataFormatException, CodecNotInitializedException
   {
      return process(data);
   }
}
