//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: wleggette
//
// Date: Feb 8, 2008
//---------------------

package org.cleversafe.codec;

import org.cleversafe.vault.VaultACL;
import org.cleversafe.vault.exceptions.VaultException;

public interface KeyedCodec extends Codec
{
   /**
    * Indicates the purpose of the operations the codec will use a specific key for. This data 
    * is used when determining what sort of access controls to apply to the key.
    */
   public enum KeyUsage
   {
      /**
       * The keys will be used for encryption.
       */
      ENCRYPTION,
      
      /**
       * The keys will be used to verify integrity.
       */
      INTEGRITY,
      
      ;
   }
   
   /**
    * Returns the purpose for the given key. This information is used to determine the permissions
    * required to access keys for this codec.
    */
   public KeyUsage getKeyUsage();
   
   /**
    * Returns the key size which the codec is configured to use.
    */
   public int getKeySize();
   
   
   /**
    * If applicable, returns the cryptographic transformation performed by this codec. Otherwise
    * returns the algorithm (where {@link #getTransformation() == #getAlgorithm()}).
    * <p>
    * For example, an encryption codec will perform a cipher transformation which has cryptographic
    * algorithm, chaining, and padding characteristics. A signature codec will create a digital
    * signature with hash algorithm and encryption algorithm characteristics.
    * <p>
    * Codecs with simpler characteristics will have a transformation string equal to the
    * algorithm string.
    */
   public String getTransformation();
   
   /**
    * Returns the base algorithm used by this codec.
    * <p>
    * This method differs from {@link #getTransformation()} in that it provides only enough
    * information to generate an algorithm-specific key.
    */
   public String getAlgorithm();
   
   
   /**
    * Sets the vault Access Control Entry (ACE) for a particular account for this vault. Codecs use 
    * the ACE to obtain required vault keys.
    */
   public void setACLEntry(VaultACL.Entry entry) throws VaultException;
   

}


