//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: May 1, 2007
//---------------------

package org.cleversafe.codec;

import org.cleversafe.codec.exceptions.CodecInvalidParametersException;
import org.cleversafe.codec.exceptions.CodecUnknownSizeChangeException;

// TODO: Describe class or interface

//TODO: implement 'modal codec stack' so that we know the context in which we're going to be called,
//will increase security in that we'll only have access to the keys necessary to perform ops
//in this context: probably modes would be write, read and rebuild

public interface Codec
{
   /**
    * @return type of codec (encryption, compression, checksum). Should be unique
    */
   String getType();

   /**
    * 
    * @return a name of codec
    */
   String getName();

   /**
    * 
    * @return
    */
   Encoder getEncoder() throws CodecInvalidParametersException;

   /**
    * 
    * @return
    */
   Decoder getDecoder() throws CodecInvalidParametersException;

   /**
    * Returns the post-encoding upper-bound size in bytes for data with a given input size.
    * 
    * @param inputSize
    * @return
    * @throws CodecUnknownSizeChangeException
    */
   long getEncodedSize(long inputSize) throws CodecUnknownSizeChangeException;
}
