//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: dhendrickson
//
// Date: Nov 8, 2007
//---------------------

package org.cleversafe.authentication;

import java.util.HashMap;
import java.util.Map;

import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

import org.cleversafe.authentication.exceptions.AuthenticationConfigurationException;

public class JAASConfiguration extends Configuration implements AuthenticationFacilitatorConfiguration
{
   private String defaultMethod;
   private Map<String,AppConfigurationEntry> authenticationConfigurationMap;
   
   public JAASConfiguration()
   {
      this.defaultMethod = "";
      this.authenticationConfigurationMap = new HashMap<String, AppConfigurationEntry>();
   }
   
   public String getDefaultMethod()
   {
      return this.defaultMethod;
   }
   
   public void setDefaultMethod(String defaultMethod)
   {
      this.defaultMethod = defaultMethod;
   }
   
   public void addAuthenticationMethod(String methodName, Class<?> className, ModuleControlFlag controlFlag, Map<String,String> options) throws AuthenticationConfigurationException
   {
      AppConfigurationEntry configEntry = new AppConfigurationEntry(className.getName(), this.jaasFlagFactory(controlFlag), options);
      
      this.authenticationConfigurationMap.put(methodName, configEntry);
   }
   
   // Normally this is paired with the enum but the enum isn't supposed to know anything about jaas.
   private AppConfigurationEntry.LoginModuleControlFlag jaasFlagFactory(ModuleControlFlag controlFlag) throws AuthenticationConfigurationException
   {
      if(controlFlag == ModuleControlFlag.OPTIONAL)
         return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
      if(controlFlag == ModuleControlFlag.REQUISITE)
         return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
      if(controlFlag == ModuleControlFlag.SUFFICIENT)
         return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
      if(controlFlag == ModuleControlFlag.REQUIRED)
         return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
      
      throw new AuthenticationConfigurationException("Invalid login module flag specified");
   }
   
   @Override
   public AppConfigurationEntry[] getAppConfigurationEntry(String name)
   {
      AppConfigurationEntry[] configEntries = new AppConfigurationEntry[1];
      
      configEntries[0] = (AppConfigurationEntry)this.authenticationConfigurationMap.get(name);
      
      return configEntries;
   }

   @Override
   public void refresh()
   {
   }
}


