//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: wleggette
//
// Date: Jan 24, 2008
//---------------------

package org.cleversafe.util;
import static org.junit.Assert.fail;

import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.martiansoftware.jsap.ParseException;

public class IQNStringParserTest
{
   private static Logger _logger = Logger.getLogger(IQNStringParserTest.class);

   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
   }

   @AfterClass
   public static void tearDownAfterClass() throws Exception
   {
   }

   @Before
   public void setUp() throws Exception
   {
   }

   @After
   public void tearDown() throws Exception
   {
   }

   
   private void testParseString(boolean valid, String str)
   {
      IQNStringParser parser = new IQNStringParser();
      try
      {
         parser.parse(str);
         if (!valid)
            fail("String unexpectedly parsed as valid: " + str);
      }
      catch (ParseException e)
      {
         if (valid)
            fail("String unexpectedly parsed as invalid: " + str);
      }
   }
   
   @Test
   public void test1()
   {
      testParseString(false, null);
   }
   
   @Test
   public void test2()
   {
      testParseString(false, "");
   }
   
   @Test
   public void test3()
   {
      testParseString(false, "iqn");
   }
   
   @Test
   public void test4()
   {
      testParseString(false, "iqn.");
   }
   
   @Test
   public void test5()
   {
      testParseString(false, "this");
   }
   
   @Test
   public void test6()
   {
      testParseString(false, "iqn.2");
   }
   
   @Test
   public void test7()
   {
      testParseString(false, "iqn.2004");
   }
   
   @Test
   public void test8()
   {
      testParseString(false, "iqn.1934-03");
   }
   
   @Test
   public void test9()
   {
      testParseString(false, "iqn.1934-03.");
   }
   
   @Test
   public void test10()
   {
      testParseString(false, "iqn.2001-04.");
   }
   
   @Test
   public void test11()
   {
      testParseString(true, "iqn.2001-04.com");
   }
   
   @Test
   public void test12()
   {
      testParseString(true, "iqn.2001-04.com.example");
   }
   
   @Test
   public void test13()
   {
      testParseString(true, "iqn.2001-04.com.example.ts.ts");
   }
   
   @Test
   public void test14()
   {
      testParseString(false, "iqn.2001-03.com.example:");
   }
   
   @Test
   public void test15()
   {
      testParseString(false, "iqn.2004-00.com.example");
   }
   
   @Test
   public void test16()
   {
      testParseString(false, "iqn.2045-13.com.example");
   }
   
   @Test
   public void test17()
   {
      testParseString(false, "iqn.2004-99.com.example");
   }
   
   @Test
   public void test18()
   {
      testParseString(false, "iqn.245-434.com.example");
   }
   
   @Test
   public void test19()
   {
      testParseString(false, "iqn.2004-eversafe:test-vault");
   }
   
   
   
   

}


