//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: bcilfone
//
// Date: Dec 11, 2007
//---------------------

package org.cleversafe.layer.iscsi.authentication.chap;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.Arrays;

import org.junit.Test;

public class ChapAuthenticationSessionTest
{
   @Test
   public void testGenerateHash()
   {
      byte identifier_byte = 5;

      byte[] challenge = new byte[]{
            1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
      };

      byte[] shared_secret = new byte[]{
            3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18
      };

      byte[] response = ChapAuthenticationSession.generateHashValue(identifier_byte, shared_secret, challenge);

      byte[] test_response = new byte[]{
            118, 16, -85, 44, -113, 14, -111, 59, 19, -123, -2, 26, 8, -108, -80, 66
      };

      assertEquals("Hash value does not match", Arrays.toString(test_response), Arrays.toString(response));
   }

   @Test
   public void testValidateResponsePacket()
   {
      byte identifier_byte = 5;

      byte[] challenge = new byte[]{
            1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
      };

      ChapChallengePacket challenge_packet = new ChapChallengePacket(identifier_byte, challenge);

      byte[] shared_secret = new byte[]{
            3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18
      };

      byte[] response = ChapAuthenticationSession.generateHashValue(identifier_byte, shared_secret, challenge);

      assertTrue("Validation returned false", ChapAuthenticationSession.validateResponsePacket(challenge_packet, response, shared_secret));
   }
}
