//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: bcilfone
//
// Date: Dec 11, 2007
//---------------------

package org.cleversafe.layer.iscsi;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;

import java.util.Arrays;

import org.cleversafe.layer.iscsi.exceptions.ISCSIBinaryValueDecodingException;
import org.junit.Test;

public class ISCSIUtilsTest
{
   @Test
   public void testEncodeHex()
   {
      byte[] bytes = {
            (byte) 0x23, (byte) 0x99, (byte) 0x00, (byte) 0xff
      };

      String bytes_encoded = ISCSIUtils.encodeBinaryValueHex(bytes);

      assertEquals("Encoded binary value hex does not match", "0x239900ff", bytes_encoded);
   }

   @Test
   public void testDecodeHex()
   {
      String bytes_encoded = "0xac01453b";

      byte[] bytes;

      try
      {
         bytes = ISCSIUtils.decodeBinaryValue(bytes_encoded);
      }
      catch (ISCSIBinaryValueDecodingException e)
      {
         assertFalse("Caught exception decoding value: " + e, true);
         return;
      }

      byte[] test_bytes = {
            (byte) 0xac, (byte) 0x01, (byte) 0x45, (byte) 0x3b
      };

      assertEquals("Decoded binary value does not match", Arrays.toString(test_bytes), Arrays.toString(bytes));
   }

   @Test
   public void testDecodeDecimal()
   {
      String bytes_encoded = "218";

      byte[] bytes;

      try
      {
         bytes = ISCSIUtils.decodeBinaryValue(bytes_encoded);
      }
      catch (ISCSIBinaryValueDecodingException e)
      {
         assertFalse("Caught exception decoding value: " + e, true);
         return;
      }

      byte[] test_bytes = {
         (byte) 0xda
      };

      assertEquals("Decoded binary value does not match", Arrays.toString(test_bytes), Arrays.toString(bytes));
   }
}
