//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: wleggette
//
// Date: Feb 1, 2008
//---------------------

package org.cleversafe.layer.access;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.File;
import java.net.URI;
import java.security.KeyPair;
import java.util.UUID;

import org.apache.log4j.Logger;
import org.cleversafe.authentication.Credentials;
import org.cleversafe.authentication.CredentialsManager;
import org.cleversafe.authentication.PropertiesFileCredentialsManager;
import org.cleversafe.authentication.PropertiesFileCredentialsManagerTest;
import org.cleversafe.authentication.exceptions.CredentialsException;
import org.cleversafe.test.BaseTest;
import org.cleversafe.test.TestException;
import org.cleversafe.util.FileSystemUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class LocalFileGridAccessDaemonTest extends BaseTest
{
   private static Logger _logger = Logger.getLogger(LocalFileGridAccessDaemonTest.class);

   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
   }

   @AfterClass
   public static void tearDownAfterClass() throws Exception
   {
   }

   @Before
   public void setUp() throws Exception
   {
   }

   @After
   public void tearDown() throws Exception
   {
   }

   public File getInputDirectory(String testName) throws TestException
   {
      return new File(super.getInputDirectory() + File.separator + testName);
   }

   public File getOutputDirectory(String testName) throws TestException
   {
      return new File(super.getOutputDirectory() + File.separator + testName);
   }
   
   private void createTestAccount(URI directory) throws Exception
   {
      // Set default credentials path
      //String orig = PropertiesFileCredentialsManager.getDefaultCredentialsPath();
      PropertiesFileCredentialsManager.setDefaultCredentialsPath(
            directory.getPath() + File.separator + GridAccessDaemon.ACCOUNTS_PATH);
      
      PropertiesFileCredentialsManagerTest.createFileFile(null, null,
            GridAccessDaemon.ACCOUNT_NAME, GridAccessDaemon.ACCOUNT_PASSWORD);
   }
   
   private void removeKeyStore(URI directory, UUID accountIdentifier) throws Exception
   {
      File keyStoreFile = new File(directory.getPath() + File.separator + 
            GridAccessDaemon.ACCOUNTS_PATH + File.separator + accountIdentifier.toString() + 
            PropertiesFileCredentialsManager.KEYSTORE_EXTENSION);
      _logger.debug("Removing key store file: " + keyStoreFile);
      keyStoreFile.delete();
   }
   
   private void removeCredentialsFile(URI directory, UUID accountIdentifier) throws Exception
   {
      File credentialsFile = new File(directory.getPath() + File.separator + 
            GridAccessDaemon.ACCOUNTS_PATH + File.separator + accountIdentifier.toString() + 
            PropertiesFileCredentialsManager.CREDENTIALS_EXTENSION);
      _logger.debug("Removing credentials file: " + credentialsFile);
      credentialsFile.delete();
   }
   
   private void removeAccountsPath(URI directory) throws Exception
   {
      File accountsDir = new File(directory.getPath() + File.separator + 
            GridAccessDaemon.ACCOUNTS_PATH);
      _logger.debug("Removing credentials file: " + accountsDir);
      FileSystemUtils.deleteDir(accountsDir);
   }
   
   
   
   
   @Test
   public void test_getCredentialsManager_AccountExists() throws Exception
   {
      URI directory = this.getOutputDirectory("test_getCredentialsManager_AccountExists").toURI();
      FileSystemUtils.deleteDir(new File(directory.getPath()));
      this.createTestAccount(directory);
      
      CredentialsManager credman = GridAccessDaemon._getCredentialsManager(directory);
      
      // Just try getting these things, the operations should not fail
      
      UUID accountIdentifier = 
         credman.getAccountIdentifier(GridAccessDaemon.ACCOUNT_NAME);
      assertTrue("account identifier fetch failed", accountIdentifier != null);
      
      KeyPair keypair =
         credman.getAccountKeyPair(accountIdentifier);
      assertTrue("account key pair fetch failed", keypair != null);
      // TODO: Find some way to compare key pairs as is done below
      
      Credentials credentials =
         credman.getCredentials(accountIdentifier);
      assertTrue("account credentials fetch failed", credentials != null);
      assertEquals("returned credentials not equal", 
            credentials, GridAccessDaemon._getCredentials(directory));
      
      assertEquals("credentials contain invalid account identifier",
            accountIdentifier,
            credentials.getAccountIdentifier());
   }
   
   @Test
   public void test_getCredentialsManager_AccountDoesNotExist() throws Exception
   {
      URI directory = this.getOutputDirectory("test_getCredentialsManager_AccountDoesNotExists").toURI();
      FileSystemUtils.deleteDir(new File(directory.getPath()));
      
      CredentialsManager credman = GridAccessDaemon._getCredentialsManager(directory);
      
      // Just try getting these things, the operations should not fail
      
      UUID accountIdentifier = 
         credman.getAccountIdentifier(GridAccessDaemon.ACCOUNT_NAME);
      assertTrue("account identifier fetch failed", accountIdentifier != null);
      
      KeyPair keypair =
         credman.getAccountKeyPair(accountIdentifier);
      assertTrue("account key pair fetch failed", keypair != null);
      // TODO: Find some way to compare key pairs as is done below
      
      Credentials credentials =
         credman.getCredentials(accountIdentifier);
      assertTrue("account credentials fetch failed", credentials != null);
      assertEquals("returned credentials not equal", 
            credentials, GridAccessDaemon._getCredentials(directory));
      
      assertEquals("credentials contain invalid account identifier",
            accountIdentifier,
            credentials.getAccountIdentifier());
   }
   

   @Test
   public void test_getCredentialsManager_NoCredentials() throws Exception
   {
      URI directory = this.getOutputDirectory("test_getCredentialsManager_CredentialsExist").toURI();
      FileSystemUtils.deleteDir(new File(directory.getPath()));
      
      CredentialsManager credman = GridAccessDaemon._getCredentialsManager(directory);
      UUID accountIdentifier = credman.getAccountIdentifier(GridAccessDaemon.ACCOUNT_NAME);
      
      this.removeCredentialsFile(directory, accountIdentifier);
      
      try
      {
         GridAccessDaemon._getCredentialsManager(directory);
         fail("Operation succeeded unexpectedly");
      }
      catch (CredentialsException e) {}
   }
   
   

   @Test
   public void test_getCredentialsManager_NoKeyStore() throws Exception
   {
      URI directory = this.getOutputDirectory("test_getCredentialsManager_NoKeyStore").toURI();
      FileSystemUtils.deleteDir(new File(directory.getPath()));
      
      CredentialsManager credman = GridAccessDaemon._getCredentialsManager(directory);
      UUID accountIdentifier = credman.getAccountIdentifier(GridAccessDaemon.ACCOUNT_NAME);
      
      this.removeKeyStore(directory, accountIdentifier);
      
      try
      {
         GridAccessDaemon._getCredentialsManager(directory);
         fail("Operation succeeded unexpectedly");
      }
      catch (CredentialsException e) {}
   }
   

   @Test
   public void test_getCredentialsManager_NoAccountDirectory() throws Exception
   {
      URI directory = this.getOutputDirectory("test_getCredentialsManager_NoAccountDirectory").toURI();
      FileSystemUtils.deleteDir(new File(directory.getPath()));
      
      CredentialsManager credman = GridAccessDaemon._getCredentialsManager(directory);
      
      this.removeAccountsPath(directory);
      
      credman = GridAccessDaemon._getCredentialsManager(directory);
      
      // Just try getting these things, the operations should not fail
      
      UUID accountIdentifier = 
         credman.getAccountIdentifier(GridAccessDaemon.ACCOUNT_NAME);
      assertTrue("account identifier fetch failed", accountIdentifier != null);
      
      KeyPair keypair =
         credman.getAccountKeyPair(accountIdentifier);
      assertTrue("account key pair fetch failed", keypair != null);
      // TODO: Find some way to compare key pairs as is done below
      
      Credentials credentials =
         credman.getCredentials(accountIdentifier);
      assertTrue("account credentials fetch failed", credentials != null);
      assertEquals("returned credentials not equal", 
            credentials, GridAccessDaemon._getCredentials(directory));
      
      assertEquals("credentials contain invalid account identifier",
            accountIdentifier,
            credentials.getAccountIdentifier());
   }
   
   

}


