//Cleversafe open-source code header - Version 1.1 - December 1, 2006

//Cleversafe Dispersed Storage(TM) is software for secure, private and
//reliable storage of the world's data using information dispersal.

//Copyright (C) 2005-2007 Cleversafe, Inc.

//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.

//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.

//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
//USA.

//Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
//Chicago IL 60616
//email licensing@cleversafe.org

//END-OF-HEADER
//-----------------------
//@author: jquigley

//Date: Oct 30, 2007
//---------------------

package org.cleversafe.layer.target;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Random;

import org.apache.log4j.Logger;
import org.cleversafe.layer.block.BlockDeviceController;
import org.cleversafe.layer.block.BlockDeviceVault;
import org.cleversafe.layer.target.lu.GridLogicalUnit;
import org.cleversafe.storage.ss.SliceServerDaemon;
import org.cleversafe.vault.FullAccountCreator;
import org.cleversafe.vault.Vault;
import org.jscsi.scsi.protocol.Command;
import org.jscsi.scsi.protocol.cdb.CDB;
import org.jscsi.scsi.protocol.cdb.Read12;
import org.jscsi.scsi.protocol.cdb.Write12;
import org.jscsi.scsi.target.DefaultTarget;
import org.jscsi.scsi.target.Target;
import org.jscsi.scsi.tasks.TaskAttribute;
import org.jscsi.scsi.transport.TestTargetTransportPort;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

//TODO: Describe class or interface
public class GridTaskUDCTest
{
   private static Logger _logger = Logger.getLogger(GridTaskUDCTest.class);

   private static int numRequests;
   private static int baseServerPort;
   private static int maxTransferBlocks;
   private static int numConcurrentRequests;
   private static TestTargetTransportPort transportPort;
   private static SliceServerDaemon ss;

   private static Target target;
   private static GridLogicalUnit lu;

   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
      _logger.debug("initializing test");

      numRequests = Integer.getInteger("test.requests", 24);
      baseServerPort = Integer.getInteger("test.server.basePort", 5000);
      numConcurrentRequests = Integer.getInteger("test.concurrency", 20);
      maxTransferBlocks = Integer.getInteger("test.maxtransfer", 100);

      String storeString = System.getProperty("org.cleversafe.ss.test.servercount");
      int numStores = storeString != null ? Integer.parseInt(storeString) : 0;

      if (numStores > 0)
      {
         _logger.info("Starting " + numStores + " slice servers " + "(base port: " + baseServerPort
               + ")");

         //ss =
         //   new SliceServerDaemon(InetAddress.getByName("127.0.0.1"), baseServerPort, false, false, numStores);
         //ss.startSliceServers();

         Thread.sleep(1000);
      }

      String vaultDescriptorPath =
         System.getProperty("org.cleversafe.block.GridTaskUDCTest.vaultDescriptor");
      assertNotNull(
            "Vault descriptor must be provided (org.cleversafe.block.GridTaskUDCTest.vaultDescriptor)",
            vaultDescriptorPath);

      FullAccountCreator accountCreator = new FullAccountCreator(vaultDescriptorPath);
      Vault vault = accountCreator.getVault();

      // Create controller
      assertTrue(vault instanceof BlockDeviceVault);

      BlockDeviceController bdc = new BlockDeviceController((BlockDeviceVault) vault);

      target = new DefaultTarget("GridTaskUDCTestTarget");
      // TODO: threading count and queue depth should be made configurable
      lu = new GridLogicalUnit(bdc);
      target.start();
      target.registerLogicalUnit(0, lu);

      transportPort = new TestTargetTransportPort(lu.getDeviceCapacity(), lu.getBlockSize());

      _logger.debug("UDC test "
            + System.getProperty("org.cleversafe.block.BlockDeviceUDCTest.vaultDescriptor")
            + "(concurrency:" + numConcurrentRequests + " requests: " + numRequests + ")");
   }

   @AfterClass
   public static void tearDownAfterClass() throws Exception
   {
      target.stop();
      if (ss != null)
      {
         ss.shutdown();
      }
      _logger.debug("exiting test");
   }

   @Before
   public void runBeforeTest() throws Exception
   {
   }

   @Test
   public void noTest()
   {
      _logger.info("********** noTest **********");
   }
   
   /////////////////////////////////////////////////////////////////////////////
   // tests

   @Test
   public void singleReadWriteComparison()
   {
      _logger.info("********** singleReadWriteComparison **********");

      long crn = 0;
      long lba = 0;

      crn = this.enqueueReadWrite(crn, lba);

      try
      {
         Thread.sleep(500);
      }
      catch (InterruptedException e)
      {
      }

      byte[] readBuf = transportPort.getReadDataMap().get(crn - 1).array();
      byte[] writeBuf = transportPort.getWriteDataMap().get(crn).array();

      Assert.assertTrue("inconsistent read/write comparison", Arrays.equals(readBuf, writeBuf));
   }

   @Test
   public void multiSyncReadWriteComparison()
   {
      _logger.info("********** multiSyncReadWriteComparison **********");

      long crn = 0;
      long lba = 0;

      for (int i=0; i < numRequests; i++)
      {
         crn = this.enqueueReadWrite(crn, lba);

         
         try
         {
            Thread.sleep(200);
         }
         catch (InterruptedException e)
         {
         }
         
         Assert.assertTrue("inconsistent read/write comparison",
               Arrays.equals(transportPort.removeReadBuffer(crn-1).array(), transportPort.removeWriteBuffer(crn).array()));

         crn += 2;
      }
      
      try
      {
         Thread.sleep(5000);
      }
      catch (InterruptedException e)
      {
         
      }
      
   }
   
   /////////////////////////////////////////////////////////////////////////////
   // utility

   public long enqueueReadWrite(long crn, long lba)
   {
      Random rnd = new Random();

      int numBlocksXfer = rnd.nextInt(maxTransferBlocks);

      _logger.info("number of blocks to transfer: " + numBlocksXfer);

      // Write
      CDB writeCDB = new Write12(0, false, false, false, false, false, lba, numBlocksXfer);
      Command writeCommand =
         new Command(transportPort.createNexus(crn), writeCDB, TaskAttribute.ORDERED, crn, 0);
      transportPort.createReadData(numBlocksXfer, crn);
      target.enqueue(transportPort, writeCommand);

      crn++;

      // Read
      CDB readCDB = new Read12(0, false, false, false, false, false, lba, numBlocksXfer);
      Command readCommand =
         new Command(transportPort.createNexus(crn), readCDB, TaskAttribute.ORDERED, crn, 0);
      target.enqueue(transportPort, readCommand);

      return crn;
   }
}
