//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: bcilfone
//
// Date: Dec 19, 2007
//---------------------

package org.cleversafe.layer.iscsi.authentication;

import org.cleversafe.layer.iscsi.exceptions.ISCSILayerException;
import org.jscsi.parser.datasegment.SettingsMap;

public interface ISCSIAuthenticationSession
{
   /**
    * The possible states of the login phase's security negotiation stage
    */
   public enum SecurityNegotiationStatus
   {
      /**
       * There is no security negotiation needed at this time
       */
      NOT_NEEDED,

      /**
       * Security negotiation is needed and we are in the process of doing it now
       */
      IN_PROGRESS,

      /**
       * Security negotiation is needed but it has completed in a failed state
       */
      COMPLETE_FAILURE,

      /**
       * Security negotiation is needed and it has completed in a successful state
       */
      COMPLETE_SUCCESS
   }

   public SecurityNegotiationStatus handleAuthenticationCheck(SettingsMap pRequestSettingsMap, SettingsMap pResponseSettingsMap, SourceOfSecrets pSourceOfSecrets) throws ISCSILayerException;
}
