//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: jquigley
//
// Date: Jan 30, 2008
//---------------------

package org.cleversafe.layer.iscsi;

import org.apache.log4j.Logger;
import org.cleversafe.layer.iscsi.authentication.SourceOfSecrets;

public class ISCSIConf
{
   private static Logger _logger = Logger.getLogger(ISCSIConf.class);

   
   private int maxDataSegmentLength = 8192;

   //  Setting this to true means the target will not allow Login without authentication
   private boolean targetRequiresAuthentication = false;
   
   
   //  This property provides the lookup of the secret for an individual user name
   private SourceOfSecrets sourceOfSecrets = new SourceOfSecrets()
   {
      public byte[] getSecret(String pName)
      {
         return "1234123412341234".getBytes();
      }
   };
   
   public ISCSIConf()
   {
      
   }
   
   public int getMaxDataSegmentLength()
   {
      return this.maxDataSegmentLength;
   }
   
   public void setMaxDataSegmentLength(int maxDataSegmentLength)
   {
      this.maxDataSegmentLength = maxDataSegmentLength;
   }
   
   public boolean getTargetRequiresAuthentication()
   {
      return this.targetRequiresAuthentication;
   }
   
   public void setTargetRequiresAuthentication(final boolean targetRequiresAuthentication)
   {
      this.targetRequiresAuthentication = targetRequiresAuthentication;
   }
   
   public SourceOfSecrets getSourceOfSecrets()
   {
      return this.sourceOfSecrets;
   }
   
}


