//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: gdhuse
//
// Date: May 5, 2007
//---------------------

package org.cleversafe.layer.block.dsd.message;
import java.io.*;
//import org.apache.log4j.Logger;

/**
 * Request from the device to write a contiguous sequence of blocks
 * to the grid.
 */
public class WriteBlocksDeviceMessage extends DeviceMessage
{
   // Protocol message type
   public static final int MESSAGE_TYPE = 0xA4;
   protected static final int MESSAGE_LENGTH = 13;
   
   //private static Logger _logger = Logger
   //      .getLogger(WriteBlocksDeviceMessage.class);   
   
   // Tag used by the device driver to associate a request with a response
   protected int requestTag;
   
   // First block to write
   protected long firstBlock;
   
   // Number of contiguous blocks to write
   protected int numBlocks;
   
   // Data of length numBlocks * blockSize
   protected byte[] data;
   
   /**
    * Construct an empty message
    */
   public WriteBlocksDeviceMessage()
   {
      this.requestTag = -1;
      this.firstBlock = -1;
      this.numBlocks  = -1;
      this.data = null;
   }
   
   /**
    * Construct a fully-formed message
    * @param requestTag Device request tag
    * @param firstBlock First block to write
    * @param numBlocks Number of blocks to write
    * @param data Block data
    */
   public WriteBlocksDeviceMessage(
         int requestTag,
         long firstBlock,
         int numBlocks,
         byte[] data )
   {  
      this.requestTag = requestTag;
      this.firstBlock = firstBlock;
      this.numBlocks  = numBlocks;
      this.data       = data;
   }
   
   public void deserialize( DataInputStream in ) throws IOException
   {
      Header header = new Header();
      header.deserialize( in, false );
      
      this.requestTag = in.readInt();
      this.firstBlock = in.readLong();
      this.numBlocks  = in.readUnsignedByte();      
      
      long length = header.length - MESSAGE_LENGTH;
      this.data = new byte[ (int)length ];
      in.readFully( this.data );
   }

   public void serialize( DataOutputStream out ) throws IOException
   {
      Header header = new Header( MESSAGE_TYPE, 
            MESSAGE_LENGTH + this.data.length );
      header.serialize( out );
      
      out.writeInt( this.requestTag );
      out.writeLong( this.firstBlock );
      out.writeByte( this.numBlocks );
            
      out.write( this.data );
   }

   public byte[] getData()
   {
      return data;
   }

   public void setData(byte[] data)
   {
      this.data = data;
   }

   public long getFirstBlock()
   {
      return firstBlock;
   }

   public void setFirstBlock(long firstBlock)
   {
      this.firstBlock = firstBlock;
   }

   public int getNumBlocks()
   {
      return numBlocks;
   }

   public void setNumBlocks(int numBlocks)
   {
      this.numBlocks = numBlocks;
   }

   public int getRequestTag()
   {
      return requestTag;
   }

   public void setRequestTag(int requestTag)
   {
      this.requestTag = requestTag;
   }
}


