//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: Jun 1, 2007
//---------------------

package org.cleversafe.layer.block.dsd;

import java.io.IOException;

import org.apache.log4j.Logger;
import org.cleversafe.layer.block.BlockDeviceVault;
import org.cleversafe.vault.Vault;
import org.cleversafe.vault.XMLVaultLoader;

// TODO: Describe class or interface
public class BlockDeviceDaemon
{
   private static Logger _logger = Logger.getLogger(BlockDeviceDaemon.class);

   // Configuration
   /*
    * public static final int GRID_PILLARS = 16; public static final int
    * IDA_THRESHOLD = 12; public static final String GRID_PATH = "Grid"; public
    * static final long DEVICE_SIZE = 32 * 1024 * 1024; public static final int
    * BLOCK_SIZE = 4096;
    */

   public static void main(String[] args)
   {
      // Parse command line parameters
      // FIXME: This is just for debugging
      int staticPort = -1;

      String configFile = "Vault-desc.xml";
      for (String arg : args)
      {
         String opt1 = "--staticPort=";
         String opt2 = "--configFile=";
         if (arg.startsWith(opt1))
         {
            staticPort = Integer.parseInt(arg.substring(opt1.length()));
         }
         else if (arg.startsWith(opt2))
         {
            configFile = arg.substring(opt2.length());
         }
      }


      try
      {
         // TODO: provide correct ACL in a valid execution context (instead of
         // null below)
         // TODO:  XMLVaultLoader should become VaultLoader when this is used again.
         Vault vaultCandiadate = new XMLVaultLoader().loadVaultFromXML(
               configFile, null);
         if (!(vaultCandiadate instanceof BlockDeviceVault))
         {
            System.err.println("Only works with block device vault");
            System.exit(-1);
         }
         BlockDeviceVault vault = (BlockDeviceVault) vaultCandiadate;

         // Create system block device
         SystemBlockDevice device;
         try
         {
            if (staticPort > 0)
            {
               // Listen on the provided port for a connection from an
               // externally-created system device
               device = new SystemBlockDevice(vault.getNumBlocks(), vault
                     .getBlockSize(), staticPort);
            }
            else
            {
               // Initiate device creation directly
               device = new SystemBlockDevice(vault.getNumBlocks(), vault
                     .getBlockSize());
            }
         }
         catch (IOException e)
         {
            _logger.error("Error creating system block device", e);
            return;
         }

         // Start controller
         SystemBlockDeviceController controller =
               new SystemBlockDeviceController(vault, device);

         controller.startup();
         
         controller.run();

         controller.shutdown();
      }
      catch (Exception ex)
      {
         System.err.println("Failed to initialize device");
         ex.printStackTrace();
         System.exit(-1);
      }

   }

}
