//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Dec 6, 2007
//---------------------

package org.cleversafe.layer.access.managers.state;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Version;

import org.cleversafe.layer.iscsi.ISCSIPortal;

@Entity
@Table(name = "SERVICE_INTERFACE")
public class ServiceInterfaceState
{
   public static final String ISCSI_INTERFACE = ISCSIPortal.ISCSI_SERVICE;
   
   @Id @GeneratedValue
   @Column(name = "SERVICE_INTERFACE_ID", nullable = false)
   private int id;
   
   @Version
   @Column(name = "OBJ_VERSION")
   private int version;
   
   @Column(name = "SERVICE_INTERFACE_TYPE", nullable = false)
   private String type;
   
   @Column(name = "SERVICE_INTERFACE_HOST", nullable = false)
   private String host;
   
   @Column(name = "SERVICE_INTERFACE_PORT", nullable = false)
   private int port;
   
   @Column(name = "SERVICE_INTERFACE_AUTOSTART", nullable = false)
   private boolean startAutomatically;

   @ManyToMany(cascade = CascadeType.ALL)
   @JoinTable(
         name = "SERVICE_TO_SERVICE_INTERFACE",
         joinColumns = {@JoinColumn(name = "SERVICE_INTERFACE_ID")},
         inverseJoinColumns = {@JoinColumn(name = "SERVICE_ID")}
   )
   private Set<ServiceState> services = new HashSet<ServiceState>();

   
   

   @Override
   public int hashCode()
   {
      final int prime = 31;
      int result = 1;
      result = prime * result + ((host == null) ? 0 : host.hashCode());
      result = prime * result + port;
      result = prime * result + ((type == null) ? 0 : type.hashCode());
      return result;
   }

   @Override
   public boolean equals(Object obj)
   {
      // Compares business keys (type, host, port)
      
      if (this == obj)
         return true;
      if (obj == null)
         return false;
      if (getClass() != obj.getClass())
         return false;
      final ServiceInterfaceState other = (ServiceInterfaceState) obj;
      if (host == null)
      {
         if (other.getHost() != null)
            return false;
      }
      else if (!host.equals(other.getHost()))
         return false;
      if (port != other.getPort())
         return false;
      if (type == null)
      {
         if (other.getType() != null)
            return false;
      }
      else if (!type.equals(other.getType()))
         return false;
      return true;
   }

   public int getId()
   {
      return id;
   }
   
   public int getVersion()
   {
      return version;
   }

   public String getType()
   {
      return type;
   }

   public void setType(String type)
   {
      this.type = type;
   }

   public String getHost()
   {
      return host;
   }

   public void setHost(String host)
   {
      this.host = host;
   }

   public int getPort()
   {
      return port;
   }

   public void setPort(int port)
   {
      this.port = port;
   }

   public boolean isStartAutomatically()
   {
      return startAutomatically;
   }

   public void setStartAutomatically(boolean startAutomatically)
   {
      this.startAutomatically = startAutomatically;
   }

   public Set<ServiceState> getServices()
   {
      final ServiceInterfaceState state = this;
      
      return new AbstractSet<ServiceState>()
      {
         @Override
         public Iterator<ServiceState> iterator()
         {
            return services.iterator();
         }

         @Override
         public int size()
         {
            return services.size();
         }

         @Override
         public boolean add(ServiceState service)
         {
            service.getModifiableServiceInterfaceSet().add(state);
            return services.add(service);
         }

         @Override
         public boolean remove(Object o)
         {
            if ( o instanceof ServiceState )
            {
               ((ServiceState)o).getModifiableServiceInterfaceSet().remove(state);
            }
            return services.remove(o);
         }
         
         
      };
   }
   
   
   
   
   
}


