//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Dec 21, 2007
//---------------------

package org.cleversafe.layer.access.jmx;

// TODO: Describe class or interface
public interface VaultStatusMBean
{
   
   /**
    * Lookup vault identifier by vault name.
    */
   String getVaultIdentifier(String vaultName) throws Exception;
   
   /**
    * Lookup vault name by vault identifier.
    */
   String getVaultName(String vaultIdentifier) throws Exception;
   
   /**
    * Returns the vault descriptor for the indicated vault.
    */
   String getVaultDescriptor(String vaultIdentifier) throws Exception;
   
   
   /**
    * Deletes the indicated vault. The vault must not currently be loaded.
    */
   void deleteVault(String vaultIdentifier) throws Exception;
   
   /**
    * Creates a new vault.
    * 
    * @param descriptor
    *           The vault descriptor.
    * @param name
    *           A human readable name for the given vault.
    * @return The UUID vault identifier of the new vault.
    */
   String createVault(String descriptor, String name) throws Exception;
   
   /**
    * Returns <code>true</code> if the indicated vault is loaded; <code>false</code> otherwise.
    */
   boolean isVaultLoaded(String vaultIdentifier) throws Exception;
   
   /**
    * Returns a list of loaded vaults by identifier.
    */
   String[] getLoadedVaults() throws Exception;
   
   /**
    * Returns the vault identifiers of all vaults accessible on the access daemon.
    */
   String[] getVaultList() throws Exception;
   
}


