//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Dec 20, 2007
//---------------------

package org.cleversafe.layer.access.jmx;

// TODO: Describe class or interface
public interface GridAccessMBean
{
   /**
    * Creates a service interface. Only one interface of a given type may be created.
    * 
    * @param type
    *           The type of service interface to create.
    * @param host
    *           The host the service interface will bind to and advertise as.
    * @param port
    *           The port the service interface will bind to.
    * @param autostart
    *           Whether the service interface will start automatically with the accesser.
    */
   void createServiceInterface(String type, String host, int port, boolean autostart)
         throws Exception;
   
   
   /**
    * Changes whether the service interface starts automatically or not.
    * 
    * @param type
    *           The type of service interface to create.
    * @param autostart
    *           Whether the service interface will start automatically with the accesser.
    */
   void changeServiceInterface(String type, boolean autostart)
         throws Exception;
   
   /**
    * Returns a list of service interfaces. Only one interface of a given type may be created.
    */
   String[] getServiceInterfaces() throws Exception;
   
   /**
    * Returns settings for the indicated service interface.
    * @return A string arary with (type, host, port, autostart, running).
    */
   String[] getServiceInterfaceSettings(String type) throws Exception;
   
   /**
    * Returns settings for all services of a given type. Each row contains an array
    * with (type, serviceName, vaultName, vaultIdentifier).
    */
   String[][] getServiceSettings(String type) throws Exception;
   
   /**
    * Returns settings for a service with the given type and name. Returns
    * an array with (type, serviceName, vaultName, vaultIdentifier).
    */
   String[] getServiceSettings(String type, String name) throws Exception;
   
   /**
    * Deletes the service with the given type and name.
    */
   void deleteService(String type, String name) throws Exception;
   
   /**
    * Removes a service interface.
    * @param type The type indicating which service interface to delete.
    */
   void deleteServiceInterface(String type) throws Exception;
   
   /**
    * Creates a service of a given type. Service names must be unique for a given service type.
    * 
    * @param type
    *           The type of service to create. Also indicates which interface the service will be
    *           available through.
    * @param name
    *           The name of the service to create. Some service types may require names of a
    *           particular format.
    * @param vault
    *           The UUID vault identifier of the vault made available through the new service.
    */
   void createService(String type, String name, String vault) throws Exception;
   

   /**
    * Returns a list of all services as "&lt;type&gt;,&lt;name&gt;" strings, where &lt;type&gt; is
    * the service type and &lt;name&gt; is the service name.
    */
   String[] getServices() throws Exception;
   
   /**
    * Returns a list of services of the given type.
    */
   String[] getServices(String type) throws Exception;
   
   /**
    * Starts the indicated service interface.
    */
   void startServiceInterface(String type) throws Exception;
   
   /**
    * Stops the indicated service interface.
    */
   void stopServiceInterface(String type) throws Exception;
   
   
   
   
}


