//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Jan 7, 2008
//---------------------

package org.cleversafe.layer.access.cli;
import java.io.File;

import org.apache.log4j.Logger;
import org.apache.log4j.extras.DOMConfigurator;
import org.cleversafe.layer.access.exceptions.AccessLayerException;
import org.cleversafe.layer.access.managers.LocalFileGridAccessManager;
import org.cleversafe.util.Log4jReloader;

// TODO: Describe class or interface
public class LocalFileDirectoryDefaults
{
   private static Logger _logger = Logger.getLogger(LocalFileDirectoryDefaults.class);

   /**
    * @param args
    */
   public static void main(String[] args)
   {
      DOMConfigurator.configure(System.getProperty("log4j.configuration"));
      Log4jReloader.launch();
      
      if (args.length < 4)
      {
         System.err.println("Usage: DIRECTORY BIND_HOST BIND_PORT AUTOSTART");
         System.exit(255);
      }
      final File directory = new File(args[0]).getAbsoluteFile();
      final String host = args[1];
      final int port = Integer.parseInt(args[2]);
      final boolean autostart = Boolean.valueOf(args[3]);
      
      LocalFileGridAccessManager manager = new LocalFileGridAccessManager();
      try
      {
         _logger.debug("Loading grid access manager");
         manager.load(directory.toURI());
         _logger.debug(String.format(
               "Creating iSCSI service interface (%s,%s,%s)", host, port, autostart));
         manager.createServiceInterface("iscsi", host, port, autostart);
         _logger.debug("Closing connection to manager.");
         manager.shutdown();
      }
      catch (AccessLayerException e)
      {
         _logger.debug("Error creating local file directory", e);
         System.err.println("Error creating local file directory.");
         System.err.println(e.getMessage());
         System.exit(10);
      }

   }

}


