//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Jan 5, 2008
//---------------------

package org.cleversafe.layer.access.cli;

import java.io.IOException;

import org.cleversafe.layer.access.GridAccessConnector;
import org.cleversafe.layer.access.jmx.GridAccessMBean;
import org.cleversafe.util.TablePrinter;

// TODO: Describe class or interface
public class ListTargets extends AbstractCLI
{
   private static final String COMMAND_NAME = "dsnet-list-targets";

   private static final String CSV_OUTPUT_FORMAT_OPTION = "csv";

   private static final String SERVICE_TYPE = "iscsi";

   ///////////////////////////////////////////////////////////////////////////////////////////////

   private final boolean csvFormat;

   public ListTargets(String[] args) throws ExitStatusException
   {
      super(ListTargets.class, COMMAND_NAME, "listing_client.jsap",
            "Lists dsNet vault iSCSI targets", args);
      this.csvFormat = this.getJSAPResult().getBoolean(CSV_OUTPUT_FORMAT_OPTION);
   }

   public ListTargets(String jmxHost, int jmxPort, boolean csvFormat)
   {
      super(COMMAND_NAME, jmxHost, jmxPort);
      this.csvFormat = csvFormat;
   }

   /**
    * Takes a list of (type, serviceName, vaultName, vaultIdentifier) listings and prints them
    * in (vaultIdentifier,serviceName,vaultName) order.
    */
   private static void printCSVFormat(String[][] data)
   {
      for (String[] elem : data)
      {
         if (elem.length != 4)
            throw new IllegalArgumentException("Insufficient data provided for service entry");
         System.out.println(elem[3] + "," + elem[1] + "," + elem[2]);
      }
   }

   public void run()
   {
      GridAccessConnector connector = this.getGridAccessConnector();

      try
      {
         connector.connect();

         GridAccessMBean gs = connector.getGridAccessMBean();

         // Get settings as array of (type, serviceName, vaultName, vaultIdentifier) arrays
         String[][] settings = gs.getServiceSettings(SERVICE_TYPE);

         if (this.csvFormat)
         {
            printCSVFormat(settings);
         }
         else
         {
            TablePrinter printer = new TablePrinter(3);
            for (String[] elem : settings)
            {
               if (elem.length != 4)
                  throw new IllegalArgumentException("Insufficient data provided for service entry");
               printer.add(elem[2], elem[1], elem[3]);
            }
            printer.print(System.out);
         }
      }
      catch (IllegalArgumentException e)
      {
         throw new ExitStatusException("Error querying data from access server", IO_ERROR, e);
      }
      catch (IOException e)
      {
         throw new ExitStatusException("Could not connect to manager on access server", IO_ERROR, e);
      }
      catch (Exception e)
      {
         throw new ExitStatusException("Error listing services on access server", UNKNOWN_ERROR, e);
      }
      finally
      {
         try
         {
            if (connector != null)
            {
               connector.close();
            }
         }
         catch (IOException e)
         {
         }
      }
   }

   public static void main(String[] args)
   {
      try
      {
         ListTargets client = new ListTargets(args);
         client.finish();
      }
      catch (ExitStatusException e)
      {
         System.exit(e.getStatus());
      }
   }

}
