//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Jan 3, 2008
//---------------------

package org.cleversafe.layer.access.cli;


public class ExitStatusException extends RuntimeException
{  
   private static final long serialVersionUID = -3788254616436589007L;
   
   private int status;

   public ExitStatusException(String msg, int status, Throwable ex)
   {
      super(msg, ex);
      this.status = status;
   }
   
   public ExitStatusException(int status, Throwable ex)
   {
      super(ex);
      this.status = status;
   }
   
   public ExitStatusException(String msg, int status)
   {
      super(msg);
      this.status = status;
   }

   public int getStatus()
   {
      return status;
   }
   
   public String toString()
   {
      StringBuffer fullMessage = new StringBuffer();
      
      fullMessage.append("Exit status " + this.status);
      
      if (getMessage() != null)
      {
         fullMessage.append(", " + getMessage());
      }
      
      if (getCause() != null && getCause().getMessage() != null)
      {
         fullMessage.append(", Caused by: ").append(getCause().getMessage());
      }
      return fullMessage.toString();
   }
   
}


