//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Jan 3, 2008
//---------------------

package org.cleversafe.layer.access.cli;
import java.io.IOException;

import javax.management.InstanceNotFoundException;

import org.cleversafe.layer.access.GridAccessConnector;
import org.cleversafe.layer.access.jmx.VaultStatusMBean;

// TODO: Describe class or interface
public class DeleteVault extends AbstractCLI
{
   private static final String COMMAND_NAME = "dsnet-delete-vault";
   
   private static final String VAULT_NAME_OPTION = "vault_name";
   

   ////////////////////////////////////////////////////////////////////////////////////////////////
   
   private final String vaultName;
   
   public DeleteVault(String[] args) throws ExitStatusException
   {
      super(DeleteVault.class,
            COMMAND_NAME,
            "delete_vault_client.jsap",
            "Deletes a dsNet vault",
            args);
      this.vaultName = getJSAPResult().getString(VAULT_NAME_OPTION);
   }
   
   public DeleteVault(String jmxHost, int jmxPort, String vaultName)
   {
      super(COMMAND_NAME, jmxHost, jmxPort);
      this.vaultName = vaultName;
   }
   
   public void run()
   {
      GridAccessConnector connector = this.getGridAccessConnector();
      
      try
      {
         connector.connect();
         
         VaultStatusMBean vs = connector.getVaultStatusMBean();
         String vaultIdentifier = vs.getVaultIdentifier(this.vaultName);
         vs.deleteVault(vaultIdentifier);
         
         System.out.println("Successfully deleted a dsNet vault.");
         System.out.println("Vault name:       " + this.vaultName);
         System.out.println("Vault identifier: " + vaultIdentifier);
      }
      catch (InstanceNotFoundException e)
      {
         throw new ExitStatusException("Error connecting to access server", IO_ERROR, e);
      }
      catch (Exception e)
      {
         throw new ExitStatusException("Error deleting vault on access server", UNKNOWN_ERROR, e);
      }
      finally
      {
         try
         {
            if (connector != null)
            {
               connector.close();
            }
         }
         catch (IOException e) {}
      }
   }
   
   public static void main(String[] args)
   {
      try
      {
         DeleteVault client = new DeleteVault(args);
         client.finish();
      }
      catch (ExitStatusException e)
      {
         System.exit(e.getStatus());
      }
   }
   
   
}


