//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Jan 4, 2008
//---------------------

package org.cleversafe.layer.access.cli;
import java.io.IOException;

import javax.management.InstanceNotFoundException;

import org.cleversafe.layer.access.GridAccessConnector;
import org.cleversafe.layer.access.jmx.GridAccessMBean;

// TODO: Describe class or interface
public class ChangePortal extends AbstractCLI
{
   private static final String COMMAND_NAME = "dsnet-change-portal";
   
   private static final String RUNNING_OPTION = "available";
   private static final String AUTOSTART_OPTION = "autostart";
   
   private static final String SERVICE_INTERFACE_TYPE = "iscsi";
   
   ////////////////////////////////////////////////////////////////////////////////////////////////
   
   private final Boolean available;
   private final Boolean autostart;
   
   public ChangePortal(String[] args) throws ExitStatusException
   {
      super(ChangePortal.class,
            COMMAND_NAME,
            "change_portal_client.jsap",
            "Changes dsNet iSCSI Portal settings",
            args);
      
      if (this.getJSAPResult().userSpecified(RUNNING_OPTION))
         this.available = this.getJSAPResult().getBoolean(RUNNING_OPTION);
      else
         this.available = null;
      
      if (this.getJSAPResult().userSpecified(AUTOSTART_OPTION))
         this.autostart = this.getJSAPResult().getBoolean(AUTOSTART_OPTION);
      else
         this.autostart = null;
   }
   
   
   
   public ChangePortal(
         String jmxHost,
         int jmxPort,
         boolean listening,
         boolean autostart)
   {
      super(COMMAND_NAME, jmxHost, jmxPort);
      this.available = listening;
      this.autostart = autostart;
   }

   

   public void run()
   {
      GridAccessConnector connector = this.getGridAccessConnector();
      
      try
      {
         connector.connect();
         
         GridAccessMBean ga = connector.getGridAccessMBean();
         
         String[] settings = ga.getServiceInterfaceSettings(SERVICE_INTERFACE_TYPE);
         
         if (settings.length < 5)
         {
            throw new ExitStatusException(
                  "Invalid portal settings returned from access server", AbstractCLI.IO_ERROR);
         }
         

         final String host = settings[1];
         final String port = settings[2];
         final boolean auto = Boolean.valueOf(settings[3]);
         final boolean running = Boolean.valueOf(settings[4]);
         
         boolean changed = false;
         
         System.out.format(
               "iSCSI Portal %s on %s:%s, %s%n",
               (running ? "available" : "not available"),
               host,
               port,
               (auto ? "starts automatically" : "does not start automatically"));
         
         if (this.available != null && this.available != running)
         {
            changed = true;
            if (!running)
            {
               ga.startServiceInterface(SERVICE_INTERFACE_TYPE);
               System.out.println("Started iSCSI portal.");
            }
            else
            {
               ga.stopServiceInterface(SERVICE_INTERFACE_TYPE);
               System.out.println("Stopped iSCSI portal.");
            }
         }
         
         if (this.autostart != null && this.autostart != auto)
         {
            changed = true;
            ga.changeServiceInterface(SERVICE_INTERFACE_TYPE, this.autostart);
            System.out.println((this.autostart ? "Enabled" : "Disabled") + " portal autostart.");
         }
         
         final boolean a = (this.available != null ? this.available : running);
         final boolean s = (this.autostart != null ? this.autostart : auto);
         
         if (changed)
         {
            System.out.println("\nChanged iSCSI Portal.");
            System.out.format(
                  "iSCSI Portal %s on %s:%s, %s%n",
                  (a ? "available" : "not available"),
                  host,
                  port,
                  (s ? "starts automatically" : "does not start automatically"));
         }
      }
      catch (InstanceNotFoundException e)
      {
         throw new ExitStatusException("Error connecting to access server", IO_ERROR, e);
      }
      catch (IOException e)
      {
         throw new ExitStatusException(
               "Could not connect to access manager on access server", IO_ERROR, e);
      }
      catch (Exception e)
      {
         throw new ExitStatusException(
               "Error changing portal on access server", UNKNOWN_ERROR, e);
      }
      finally
      {
         try
         {
            if (connector != null)
            {
               connector.close();
            }
         }
         catch (IOException e) {}
      }
   }
   
   public static void main(String[] args)
   {
      try
      {
         ChangePortal client = new ChangePortal(args);
         client.finish();
      }
      catch (ExitStatusException e)
      {
         System.exit(e.getStatus());
      }
   }

}


