//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Dec 3, 2007
//---------------------

package org.cleversafe.layer.access;

import java.util.List;
import java.util.UUID;

import org.cleversafe.layer.access.exceptions.InvalidVaultLoadException;
import org.cleversafe.layer.access.exceptions.InvalidVaultTypeException;
import org.cleversafe.layer.access.exceptions.ServiceConfigurationException;
import org.cleversafe.vault.Vault;

/**
 * An interface representing a single generic network service. Services are made available through
 * a service interface. Examples of services include a single file share or an iSCSI target.
 * A service implementation will generally be closely related to a service interface implementation.
 * <p>
 * Service instances must be created in order to add them to service interfaces. The actual
 * servicing behavior should not start until the service is added to a running service interface
 * (adding to stopped service interfaces should not trigger servicing). With this in mind, make
 * service instantiation lightweight and leave any heavy initialization until the service
 * is actually started when added to the service interface. The interface used to start a service
 * is specific to the service-service interface pair.
 */
public interface Service
{
   
   /**
    * Returns the type of network service provided by this object. Services may only be added
    * to identically typed service interfaces.
    */
   String getType();

   /**
    * The service name. Service names must be unique within any service interface instance.
    */
   String getName();
   
   UUID getVaultIdentifier();

   Service load(String name, Vault vault) throws InvalidVaultTypeException,
         ServiceConfigurationException, InvalidVaultLoadException;

   List<String> getSupportedVaultTypes();
}
