//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Jan 3, 2008
//---------------------

package org.cleversafe.layer.access;
import java.io.IOException;

import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

import org.cleversafe.layer.access.jmx.GridAccessMBean;
import org.cleversafe.layer.access.jmx.VaultStatusMBean;

// TODO: Describe class or interface
public class GridAccessConnector
{
   private JMXServiceURL url;
   private JMXConnector connector;
   
   public GridAccessConnector(String host, int port) throws IOException
   {
      this.url = new JMXServiceURL(
            "service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/jmxrmi");
   }
   
   public GridAccessConnector(JMXServiceURL url) throws IOException
   {
      this.url = url;
   }
   
   public void connect() throws IOException
   {
      this.connector = JMXConnectorFactory.connect(url);
   }
   
   public void close() throws IOException
   {
      if (this.connector != null)
      {
         this.connector.close();
      }
   }
   
   public GridAccessMBean getGridAccessMBean() throws IOException
   {
      return (GridAccessMBean) MBeanServerInvocationHandler.newProxyInstance(
            this.connector.getMBeanServerConnection(),
            GridAccessDaemon.GRID_ACCESS_OBJECT_NAME,
            GridAccessMBean.class,
            false);
   }
   
   public VaultStatusMBean getVaultStatusMBean() throws IOException
   {
      return (VaultStatusMBean) MBeanServerInvocationHandler.newProxyInstance(
            this.connector.getMBeanServerConnection(),
            GridAccessDaemon.VAULT_STATUS_OBJECT_NAME,
            VaultStatusMBean.class,
            false);
   }
   

   public static void main(String[] args) throws Exception
   {
      JMXServiceURL url = new JMXServiceURL(
            "service:jmx:rmi://127.0.0.1/jndi/rmi://localhost:1099/jmxrmi");
      JMXConnector c = JMXConnectorFactory.connect(url);
      
      ObjectName name = new ObjectName("org.cleversafe.layer.access.jmx:type=GridAccess");
      
      Object obj = c.getMBeanServerConnection().getAttribute(name, "ServiceInterfaces");
      if (obj instanceof String[])
      {
         for (String str : (String[])obj)
         {
            System.out.println(str);
         }
      }
      else
      {
         System.err.println("Could not read attribute");
      }
      
      System.out.println("Getting proxy object");
      
      GridAccessMBean proxy = (GridAccessMBean) 
            MBeanServerInvocationHandler.newProxyInstance(
                  c.getMBeanServerConnection(), 
                  name, 
                  GridAccessMBean.class, 
                  false);
      
      System.out.println("---------------------\nService Interfaces:");
      for (String str : proxy.getServiceInterfaces())
      {
         System.out.println(str);
      }
      
      System.out.println("---------------------\nServices:");
      for (String str : proxy.getServices())
      {
         System.out.println(str);
      }
      
      proxy.createServiceInterface("iscsi", "0.0.0.0", 3260, true);
      
   }
   
   
   
}


