@echo off
rem
rem A simple script for installing both the bus and function drivers.
rem Run build -c to build the drivers before installing
rem

set instdir=dist
set log=install.log

echo Creating installation package...
mkdir %instdir% 2> %log%
copy dsdbus\dsdbus.inf %instdir% >> %log%
copy dsdbus\WdfCoInstaller01005.dll %instdir%  >> %log%
copy dsdbus\objchk_wxp_x86\i386\dsdbus.sys %instdir% >> %log%
copy dsd\dsd.inf %instdir% >> %log%
copy dsd\objchk_wxp_x86\i386\dsd.sys %instdir% >> %log%

cd %instdir% >> %log%
stampinf -f dsd.inf -d * -v * >> %log%
stampinf -f dsdbus.inf -d * -v * >> %log%

echo Digitally signing package...
certmgr -del -all -s PrivateCertStore >> %log%
certmgr -del %CD%\testcert.cer -s -r localMachine root >> %log%
certmgr -del %CD%\testcert.cer -s -r localMachine trustedpublisher >> %log%
del testcert.cer >> %log%
Makecert -r -pe -ss PrivateCertStore -n "CN=TestCertforWDK" TestCert.cer >> %log%
signability /driver:%CD% /auto /cat /os:296 >> %log%
taskkill /FI "WINDOWTITLE eq signability*" >> %log%
SignTool sign /s PrivateCertStore %CD%\dsd.cat >> %log%
certmgr -add %CD%\testcert.cer -s -r localMachine root >> %log%
certmgr -add %CD%\testcert.cer -s -r localMachine trustedpublisher >> %log%

echo Performing installation...
devcon.exe remove dsdbus >> %log%
del %windir%\system32\drivers\dsd.sys 2>> %log%
del %windir%\system32\drivers\dsdbus.sys 2>> %log%
devcon.exe install dsdbus.inf dsdbus >> %log%

cd .. >> %log%
echo Installation complete
