/**
 * Cleversafe open-source code header - Version 1.1 - December 1, 2006
 *
 * Cleversafe Dispersed Storage(TM) is software for secure, private and
 * reliable storage of the world's data using information dispersal.
 *
 * Copyright (C) 2005-2007 Cleversafe, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 * Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
 * Chicago IL 60616
 * email licensing@cleversafe.org
 *
 * Author: Greg Dhuse <gdhuse@cleversafe.com>
 *
 */
#ifndef DSD_WIN_COMMON_H
#define DSD_WIN_COMMON_H

#include <ntddk.h>
#include <wdf.h>

#include "dsd_common.h"

#define DSD_DEVICE_ID      L"DSDBUS\\dsd"

/**
 * Define device structure to be stored in device object's context.
 * To retrieve: PDSD_DEV myDev = GetDsd( device )
 */
typedef struct _DSD_DEV
{
   WDFSTRING   deviceName;       // Assigned device name (eg. /Device/Foo)

   uint64_t    numBlocks;        // Number of numBlocks
   uint16_t    blockSize;        // Sector size in bytes
   
   WDFQUEUE    defaultQueue;     // Default IO Queue
   WDFQUEUE    pendingQueue;     // Manual queue of pending requests

   LONG        error;            // Atomic: Error state (NTSTATUS)
   LONG        pendingWork;      // Atomic: No. in-flight workitems

   int         socket;           // Kernel socket
   WDFWAITLOCK socketLock;       // Socket mutex
   HANDLE      thread;           // Device thread

} DSD_DEV, *PDSD_DEV;
WDF_DECLARE_CONTEXT_TYPE_WITH_NAME( DSD_DEV, GetDsd );

/**
 * Context for the bus-enumerated PDO
 */
typedef struct _DSD_PDO
{
   uint64_t numBlocks;           // Number of blocks on the device
   uint16_t blockSize;           // Size of a block in bytes

   int socket;                   // Connected daemon socket

} DSD_PDO, *PDSD_PDO;
WDF_DECLARE_CONTEXT_TYPE_WITH_NAME( DSD_PDO, GetDsdPdo );

#endif
