/**
 * Cleversafe open-source code header - Version 1.1 - December 1, 2006
 *
 * Cleversafe Dispersed Storage(TM) is software for secure, private and
 * reliable storage of the world's data using information dispersal.
 *
 * Copyright (C) 2005-2007 Cleversafe, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 * Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
 * Chicago IL 60616
 * email licensing@cleversafe.org
 *
 * Author: Greg Dhuse <gdhuse@cleversafe.com>
 *
 */

#include "dsd.h"

/*******************************************************************************
 * DISCLAIMER: Cleaning up these ioctls is near the top of my TODO list.  I
 *             suggest coming back once I'm done. =)
 ******************************************************************************/

static void GetPartitionInformationEx( PDSD_DEV dsd, PPARTITION_INFORMATION_EX partInfo );
static void GetPartitionInformation( PDSD_DEV dsd, PPARTITION_INFORMATION partInfo );
static void GetDiskDetectionInfo( PDISK_DETECTION_INFO detInfo );
static void GetDiskPartitionInfo( PDSD_DEV dsd, PDISK_PARTITION_INFO partInfo );
static void GetDiskGeometry( PDSD_DEV dsd, PDISK_GEOMETRY geometry );

#if 0
/**
 * IOCTL helpers
 */
/* Mount manager */
static NTSTATUS IOCTLMountdevQueryDeviceName( 
   IN PDSD_DEV device, OUT PVOID buffer, IN size_t length, OUT ULONG_PTR* info );

/* Disk */
static NTSTATUS IOCTLDiskCheckVerify( 
   IN PDSD_DEV device, OUT PVOID buffer, IN size_t length, OUT ULONG_PTR* info );
static NTSTATUS IOCTLDiskGetLengthInfo( 
   IN PDSD_DEV device, OUT PVOID buffer, IN size_t length, OUT ULONG_PTR* info );
static NTSTATUS IOCTLDiskIsWritable( 
   IN PDSD_DEV device, OUT PVOID buffer, IN size_t length, OUT ULONG_PTR* info );
static NTSTATUS IOCTLDiskMediaRemoval( 
   IN PDSD_DEV device, OUT PVOID buffer, IN size_t length, OUT ULONG_PTR* info );

/* Disk geometry & partitions */
static NTSTATUS IOCTLDiskGetPartitionInfo( 
   IN PDSD_DEV device, OUT PVOID buffer, IN size_t length, OUT ULONG_PTR* info );
static NTSTATUS IOCTLDiskGetPartitionInfoEx( 
   IN PDSD_DEV device, OUT PVOID buffer, IN size_t length, OUT ULONG_PTR* info );
static NTSTATUS IOCTLDiskGetDriveLayoutEx( 
   IN PDSD_DEV device, OUT PVOID buffer, IN size_t length, OUT ULONG_PTR* info );
static NTSTATUS IOCTLDiskGetDeviceNumber( 
   IN PDSD_DEV device, OUT PVOID buffer, IN size_t length, OUT ULONG_PTR* info );
static NTSTATUS IOCTLDiskGetDriveGeometry( 
   IN PDSD_DEV device, OUT PVOID buffer, IN size_t length, OUT ULONG_PTR* info );
static NTSTATUS IOCTLDiskGetDriveGeometryEx( 
   IN PDSD_DEV device, OUT PVOID buffer, IN size_t length, OUT ULONG_PTR* info );

/* Storage */
static NTSTATUS IOCTLStorageGetDeviceNumber( 
   IN PDSD_DEV device, OUT PVOID buffer, IN size_t length, OUT ULONG_PTR* info );
static NTSTATUS IOCTLStorageGetHotplugInfo( 
   IN PDSD_DEV device, OUT PVOID buffer, IN size_t length, OUT ULONG_PTR* info );

/* Formatting */
static NTSTATUS IOCTLDiskVerify( 
   IN PDSD_DEV device, IN PVOID buffer, IN size_t length, OUT ULONG_PTR* info );
static NTSTATUS IOCTLDiskSetPartitionInfo( 
   IN PDSD_DEV device, IN PVOID buffer, IN size_t length, OUT ULONG_PTR* info );
#endif


VOID
EvtDeviceIoDeviceControl( IN WDFQUEUE queue, 
                          IN WDFREQUEST request, 
                          IN size_t outputBufferLength,
                          IN size_t inputBufferLength,
                          IN ULONG ioControlCode )
{
   NTSTATUS status;
   PVOID buffer;
   WDFDEVICE device;
   PDSD_DEV dsd = NULL;

   UNREFERENCED_PARAMETER( inputBufferLength );
   UNREFERENCED_PARAMETER( outputBufferLength );

   KdPrint(( DSD_TAG "--> EvtDeviceIoDeviceControl (ioctl:0x%08x)\n", 
      ioControlCode ));

   device = WdfIoQueueGetDevice( queue );
   dsd = GetDsd( device );

   switch( ioControlCode )
   {
      case IOCTL_DISK_GET_PARTITION_INFO:
      {
         PPARTITION_INFORMATION pinfo;

         KdPrint(( DSD_TAG "IOCTL_DISK_GET_PARTITION_INFO\n" ));
#if 1         
         status = WdfRequestRetrieveOutputBuffer( 
            request, sizeof(PARTITION_INFORMATION), 
            &buffer, NULL );
         if( status == STATUS_BUFFER_TOO_SMALL )
         {
            KdPrint(( DSD_TAG "Buffer too small: 0x%08x\n", status ));
            break;
         }

         pinfo = (PPARTITION_INFORMATION)buffer;
         RtlZeroMemory( pinfo, sizeof(PARTITION_INFORMATION) );
         GetPartitionInformation( dsd, pinfo );

         WdfRequestSetInformation( request, sizeof(PARTITION_INFORMATION) );
         status = STATUS_SUCCESS;   
         KdPrint(( DSD_TAG "Success!\n" ));
#endif
#if 0
         WdfRequestSetInformation( request, 0 );
         status = STATUS_NOT_FOUND;
#endif
      }
      break;

      /************************************************************************/

      case IOCTL_DISK_GET_PARTITION_INFO_EX:
      {
         PPARTITION_INFORMATION_EX pinfo;

         KdPrint(( DSD_TAG "IOCTL_DISK_GET_PARTITION_INFO_EX\n" ));
         
         status = WdfRequestRetrieveOutputBuffer( 
            request, sizeof(PARTITION_INFORMATION_EX), 
            &buffer, NULL );
         if( status == STATUS_BUFFER_TOO_SMALL )
         {
            KdPrint(( DSD_TAG "Buffer too small: 0x%08x\n", status ));
            break;
         }
         else if( !NT_SUCCESS(status) )
         {
            KdPrint(( DSD_TAG "Cannot get buffer: 0x%08x\n", status ));
            break;
         }

         pinfo = (PPARTITION_INFORMATION_EX)buffer;
         RtlZeroMemory( pinfo, sizeof(PARTITION_INFORMATION_EX) );
         GetPartitionInformationEx( dsd, pinfo );

         WdfRequestSetInformation( request, sizeof(PARTITION_INFORMATION_EX) );
         status = STATUS_SUCCESS;   
         KdPrint(( DSD_TAG "Success!\n" ));
      }
      break;
      
      /************************************************************************/
      
      case IOCTL_DISK_GET_DRIVE_GEOMETRY:
      {
         PDISK_GEOMETRY geometry;

         KdPrint(( DSD_TAG "IOCTL_DISK_GET_DRIVE_GEOMETRY\n" ));

         status = WdfRequestRetrieveOutputBuffer( 
            request, sizeof(DISK_GEOMETRY), 
            &buffer, NULL );
         if( status == STATUS_BUFFER_TOO_SMALL )
         {
            KdPrint(( DSD_TAG "Buffer too small: 0x%08x\n", status ));
            WdfRequestSetInformation( request, 0 );
            break;
         }

         geometry = (PDISK_GEOMETRY)buffer;
         RtlZeroMemory( geometry, sizeof(DISK_GEOMETRY) );
         GetDiskGeometry( dsd, geometry );

         WdfRequestSetInformation( request, sizeof(DISK_GEOMETRY) );
         status = STATUS_SUCCESS;   
         KdPrint(( DSD_TAG "Success!\n" ));
      }
      break;

      /************************************************************************/

      case IOCTL_DISK_GET_DRIVE_GEOMETRY_EX:
       {
         PDISK_GEOMETRY_EX geometry;

         /**
          * This undocumented hackery comes from disk.c... 
          * sometimes a request comes in with a buffer of this size and 
          * is not retried if failed with STATUS_BUFFER_TOO_SMALL
          */
         int size = FIELD_OFFSET( DISK_GEOMETRY_EX, Data );

         KdPrint(( DSD_TAG "IOCTL_DISK_GET_DRIVE_GEOMETRY_EX\n" ));
         
         status = WdfRequestRetrieveOutputBuffer( 
            request, size, 
            &buffer, NULL );
         if( status == STATUS_BUFFER_TOO_SMALL )
         {
            KdPrint(( DSD_TAG "Buffer too small: 0x%08x\n", status ));
            WdfRequestSetInformation( request, 0 );
            break;
         }
         else if( !NT_SUCCESS(status) )
         {
            KdPrint(( DSD_TAG "Cannot get buffer: 0x%08x\n", status ));
            break;
         }

         geometry = (PDISK_GEOMETRY_EX)buffer;
         RtlZeroMemory( geometry, size );
         
         GetDiskGeometry( dsd, (PDISK_GEOMETRY)&geometry->Geometry );
         geometry->DiskSize.QuadPart = dsd->numBlocks * dsd->blockSize;

         /* FIXME
         GetDiskPartitionInfo( DiskGeometryGetPartition( geometry ) );
         GetDiskDetectionInfo( DiskGeometryGetDetect( geometry ) );
         */
         
         WdfRequestSetInformation( request, size );
         status = STATUS_SUCCESS;   
         KdPrint(( DSD_TAG "Success!\n" ));
      }
      break;

      /************************************************************************/

      case IOCTL_STORAGE_CHECK_VERIFY:
      case IOCTL_DISK_CHECK_VERIFY:
      {
         KdPrint(( DSD_TAG "IOCTL_DISK_CHECK_VERIFY\n" ));

         /* 
          * Return the number of times media has changed only if
          * the caller provides a buffer for it
          */
         status = WdfRequestRetrieveOutputBuffer( 
            request, sizeof(ULONG), 
            &buffer, NULL );
         if( NT_SUCCESS(status) )
         {
            ULONG mediaChange = 0;  /* Media never changes */
            RtlCopyMemory( buffer, &mediaChange, sizeof(ULONG) );
            WdfRequestSetInformation( request, sizeof(ULONG) );
         }
         else
         {
            WdfRequestSetInformation( request, 0 );
         }
                  
         status = STATUS_SUCCESS;   
         KdPrint(( DSD_TAG "Success!\n" ));
      }
      break;   

      /************************************************************************/

      case IOCTL_DISK_IS_WRITABLE:
      {
         KdPrint(( DSD_TAG "IOCTL_DISK_IS_WRITABLE\n" ));

         /* Note: for read-only: STATUS_MEDIA_WRITE_PROTECTED */
   
         /* Media is read-write */
         WdfRequestSetInformation( request, 0 );
         status = STATUS_SUCCESS;
         KdPrint(( DSD_TAG "Success!\n" ));
      }
      break;

      /************************************************************************/

      case IOCTL_VOLUME_GET_GPT_ATTRIBUTES:
         KdPrint(( DSD_TAG "IOCTL_VOLUME_GET_GPT_ATTRIBUTES\n" ));
         /* Where is this documented?? */
         status = STATUS_NOT_IMPLEMENTED;
         break;

      /************************************************************************/

      case IOCTL_STORAGE_GET_DEVICE_NUMBER:
      {
         PSTORAGE_DEVICE_NUMBER pdnum;

         KdPrint(( DSD_TAG "IOCTL_STORAGE_GET_DEVICE_NUMBER\n" ));
         
         status = WdfRequestRetrieveOutputBuffer( 
            request, sizeof(STORAGE_DEVICE_NUMBER), 
            &buffer, NULL );
         if( status == STATUS_BUFFER_TOO_SMALL )
         {
            KdPrint(( DSD_TAG "Buffer too small: 0x%08x\n", status ));
            break;
         }
         else if( !NT_SUCCESS(status) )
         {
            KdPrint(( DSD_TAG "Cannot get buffer: 0x%08x\n", status ));
            break;
         }

         pdnum = (PSTORAGE_DEVICE_NUMBER)buffer;
         RtlZeroMemory( pdnum, sizeof(STORAGE_DEVICE_NUMBER) );

         pdnum->DeviceType       = /*FILE_DEVICE_MASS_STORAGE*/ FILE_DEVICE_DISK;
         pdnum->DeviceNumber     = 42;  /* ? */
         pdnum->PartitionNumber  = 0;  /* ? */

         WdfRequestSetInformation( request, sizeof(STORAGE_DEVICE_NUMBER) );
         status = STATUS_SUCCESS;   
            KdPrint(( DSD_TAG "Success!\n" ));
      }
      break;

      /************************************************************************/

      case IOCTL_MOUNTDEV_QUERY_DEVICE_NAME:
      {
         int size;
         PMOUNTDEV_NAME name;
         UNICODE_STRING us;

         KdPrint(( DSD_TAG "IOCTL_MOUNTDEV_QUERY_DEVICE_NAME\n" ));

         WdfStringGetUnicodeString( dsd->deviceName, &us );

         /* Ensure that the buffer is large enough */
         size = sizeof(USHORT) + us.Length + 1;
         status = WdfRequestRetrieveOutputBuffer( 
            request, size, &buffer, NULL );
         if( status == STATUS_BUFFER_TOO_SMALL )
         {
            KdPrint(( DSD_TAG "Buffer too small: 0x%08x\n", status ));
            status = STATUS_BUFFER_OVERFLOW;
            WdfRequestSetInformation( request, sizeof(MOUNTDEV_NAME) );
            break;
         }
         else if( !NT_SUCCESS(status) )
         {
            KdPrint(( DSD_TAG "Cannot get buffer: 0x%08x\n", status ));
            break;
         }

         name = (PMOUNTDEV_NAME)buffer;
         RtlZeroMemory( name, sizeof(MOUNTDEV_NAME) );
         name->NameLength = us.Length;
         
         status = RtlStringCchCopyUnicodeString( name->Name, name->NameLength, &us );
         if( !NT_SUCCESS(status) )
         {
            KdPrint(( DSD_TAG "Unsuccessful copy: 0x%08x\n", status ));
            break;
         }

         KdPrint(( DSD_TAG "Success! '%ws'(%d)\n", name->Name, name->NameLength ));
         WdfRequestSetInformation( request, name->NameLength + 1 );
         status = STATUS_SUCCESS;
      }
      break;

      /************************************************************************/

      case IOCTL_MOUNTDEV_QUERY_UNIQUE_ID:
         KdPrint(( DSD_TAG "IOCTL_MOUNTDEV_QUERY_UNIQUE_ID\n" ));
         status = STATUS_NOT_IMPLEMENTED;
         break;

      /************************************************************************/

      case IOCTL_MOUNTDEV_QUERY_SUGGESTED_LINK_NAME:
         KdPrint(( DSD_TAG "IOCTL_MOUNTDEV_QUERY_SUGGESTED_LINK_NAME\n" ));
         status = STATUS_NOT_IMPLEMENTED;
         break;

      /************************************************************************/

      case IOCTL_DISK_GET_DRIVE_LAYOUT_EX:
      {
#if 0
         PDRIVE_LAYOUT_INFORMATION_EX layout;
         int size = sizeof( DRIVE_LAYOUT_INFORMATION_EX ) /*+
                    1 * sizeof( PARTITION_INFORMATION_EX )*/;
#endif

         KdPrint(( DSD_TAG "IOCTL_DISK_GET_DRIVE_LAYOUT_EX\n" ));

#if 0
         status = WdfRequestRetrieveOutputBuffer( 
            request, size, 
            &buffer, NULL );
         if( status == STATUS_BUFFER_TOO_SMALL )
         {
            KdPrint(( DSD_TAG "Buffer too small: 0x%08x\n", status ));
            break;
         }
         else if( !NT_SUCCESS(status) )
         {
            KdPrint(( DSD_TAG "Cannot get buffer: 0x%08x\n", status ));
            break;
         }

         layout = (PDRIVE_LAYOUT_INFORMATION_EX)buffer;
         RtlZeroMemory( layout, size );

         layout->PartitionStyle  = PARTITION_STYLE_MBR;
         layout->PartitionCount  = 1;  /* ? */
         layout->Mbr.Signature   = 0;  /* ? */

         GetPartitionInformationEx( layout->PartitionEntry );
         
         KdPrint(( DSD_TAG "Success!\n" ));
         WdfRequestSetInformation( request, size );
         status = STATUS_SUCCESS;
#endif

         WdfRequestSetInformation( request, 0 );
         status = STATUS_NOT_FOUND;
      }
      break;

      /************************************************************************/

      case IOCTL_STORAGE_GET_MEDIA_TYPES_EX:
      {
         KdPrint(( DSD_TAG "IOCTL_STORAGE_GET_MEDIA_TYPES_EX\n" ));
         status = STATUS_NOT_FOUND;
      }
      break;

      case IOCTL_STORAGE_GET_HOTPLUG_INFO:
      {
         KdPrint(( DSD_TAG "IOCTL_STORAGE_GET_HOTPLUG_INFO\n" ));
         status = STATUS_NOT_FOUND;
      }
      break;

      /************************************************************************/

      case IOCTL_DISK_GET_LENGTH_INFO:
      {
         PGET_LENGTH_INFORMATION lengthInfo;

         KdPrint(( DSD_TAG "IOCTL_DISK_GET_LENGTH_INFO\n" ));
         
         status = WdfRequestRetrieveOutputBuffer( 
            request, sizeof(GET_LENGTH_INFORMATION), 
            &buffer, NULL );
         if( status == STATUS_BUFFER_TOO_SMALL )
         {
            KdPrint(( DSD_TAG "Buffer too small: 0x%08x\n", status ));
            break;
         }

         lengthInfo = (PGET_LENGTH_INFORMATION)buffer;
         RtlZeroMemory( lengthInfo, sizeof(GET_LENGTH_INFORMATION) );

         lengthInfo->Length.QuadPart = dsd->numBlocks * dsd->blockSize;
         
         WdfRequestSetInformation( request, sizeof(GET_LENGTH_INFORMATION) );
         status = STATUS_SUCCESS;   
         KdPrint(( DSD_TAG "Success!\n" ));
      }
      break;

      /************************************************************************/

      case IOCTL_STORAGE_MEDIA_REMOVAL:
      case IOCTL_DISK_MEDIA_REMOVAL:
      {
         KdPrint(( DSD_TAG "IOCTL_DISK_MEDIA_REMOVAL\n" ));
         
         /* 
          * Caller requests that the media be locked to prevent removal,
          * we always reply with success
          */
         WdfRequestSetInformation( request, 0 );
         status = STATUS_SUCCESS;
         KdPrint(( DSD_TAG "Success!\n" ));
      }
      break;

      /************************************************************************/

      /* Request to format a piece of the disk */
      case IOCTL_DISK_VERIFY:
      {
         PVERIFY_INFORMATION verify;

         KdPrint(( DSD_TAG "IOCTL_DISK_VERIFY\n" ));

         /* Note: This is an input buffer */
         status = WdfRequestRetrieveInputBuffer( 
            request, sizeof(VERIFY_INFORMATION), 
            &buffer, NULL );
         if( status == STATUS_BUFFER_TOO_SMALL )
         {
            KdPrint(( DSD_TAG "Buffer too small: 0x%08x\n", status ));
            break;
         }

         /* FIXME: Perform logical formatting */
         verify = (PVERIFY_INFORMATION)buffer;

         WdfRequestSetInformation( request, 0 );
         status = STATUS_SUCCESS;   
         KdPrint(( DSD_TAG "Success!\n" ));
      }
      break;
      
      /************************************************************************/

      /* Request to set a new partition table */
      case IOCTL_DISK_SET_PARTITION_INFO:
      {
         PSET_PARTITION_INFORMATION partInfo;

         KdPrint(( DSD_TAG "IOCTL_DISK_SET_PARTITION_INFO\n" ));

         /* Note: This is an input buffer */
         status = WdfRequestRetrieveInputBuffer( 
            request, sizeof(SET_PARTITION_INFORMATION), 
            &buffer, NULL );
         if( status == STATUS_BUFFER_TOO_SMALL )
         {
            KdPrint(( DSD_TAG "Buffer too small: 0x%08x\n", status ));
            break;
         }
         
         /* FIXME: Do we need to do anything here? */
         partInfo = (PSET_PARTITION_INFORMATION)buffer;

         WdfRequestSetInformation( request, 0 );
         status = STATUS_SUCCESS;   
         KdPrint(( DSD_TAG "Success!\n" ));
      }
      break;

      /************************************************************************/

      default:
         KdPrint(( DSD_TAG "Unknown ioctl\n" ));
         status = STATUS_NOT_IMPLEMENTED;         
         break;
   }

   WdfRequestComplete( request, status );   
   KdPrint(( DSD_TAG "<-- EvtDeviceIoDeviceControl(%x)\n", status ));
}

/**
 * Populates a DISK_GEOMETRY structure
 */
static void GetDiskGeometry( PDSD_DEV dsd, PDISK_GEOMETRY geometry )
{
   geometry->BytesPerSector      = dsd->blockSize;
   geometry->SectorsPerTrack     = 32;       /* ? */
   geometry->TracksPerCylinder   = 2;        /* ? */
   geometry->Cylinders.QuadPart  = dsd->numBlocks * dsd->blockSize / 
                                   geometry->BytesPerSector /
                                   geometry->SectorsPerTrack /
                                   geometry->TracksPerCylinder;
   geometry->MediaType           = FixedMedia;
}

static void GetDiskPartitionInfo( PDSD_DEV dsd, PDISK_PARTITION_INFO partInfo )
{
   /* FIXME: Is this just the structure size? */
   partInfo->SizeOfPartitionInfo = (ULONG)(dsd->numBlocks * dsd->blockSize);
   partInfo->PartitionStyle      = PARTITION_STYLE_MBR;
   partInfo->Mbr.Signature       = 0;  /* ? */
   partInfo->Mbr.CheckSum        = 0;  /* ? */
}

static void GetDiskDetectionInfo( PDISK_DETECTION_INFO detInfo )
{
   detInfo->SizeOfDetectInfo  = 0;           /* ? */
   detInfo->DetectionType     = DetectNone;  /* ? */
}

static void GetPartitionInformation( PDSD_DEV dsd, PPARTITION_INFORMATION partInfo )
{
   partInfo->StartingOffset.QuadPart   = 0;
   partInfo->PartitionLength.QuadPart  = dsd->numBlocks * dsd->blockSize;;
   partInfo->HiddenSectors             = 0;
   partInfo->PartitionNumber           = 0;
   partInfo->PartitionType             = PARTITION_ENTRY_UNUSED;
   partInfo->BootIndicator             = FALSE;
   partInfo->RecognizedPartition       = FALSE;
   partInfo->RewritePartition          = FALSE;
}

static void GetPartitionInformationEx( PDSD_DEV dsd, PPARTITION_INFORMATION_EX partInfo )
{
   PPARTITION_INFORMATION_MBR pmbr;
         
   partInfo->PartitionStyle            = PARTITION_STYLE_MBR;
   partInfo->StartingOffset.QuadPart   = 0;
   partInfo->PartitionLength.QuadPart  = dsd->numBlocks * dsd->blockSize;;
   partInfo->PartitionNumber  = 0;     /* ? */
   partInfo->RewritePartition = FALSE; /* ? */
         
   /* MBR Information */
   pmbr = &partInfo->Mbr;
   pmbr->PartitionType        = PARTITION_FAT32; /* ? */
   pmbr->BootIndicator        = FALSE;
   pmbr->RecognizedPartition  = TRUE ;  /* ? */
   pmbr->HiddenSectors        = 1;      /* ? */
}