/**
 * Cleversafe open-source code header - Version 1.1 - December 1, 2006
 *
 * Cleversafe Dispersed Storage(TM) is software for secure, private and
 * reliable storage of the world's data using information dispersal.
 *
 * Copyright (C) 2005-2007 Cleversafe, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 * Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
 * Chicago IL 60616
 * email licensing@cleversafe.org
 *
 * Author: Greg Dhuse <gdhuse@cleversafe.com>
 *
 */
#ifndef DSD_COMMON_H
#define DSD_COMMON_H

#if defined(linux) && defined(__KERNEL__)    /* Linux kernel */
#include <linux/types.h>
#elif defined(linux)                         /* Linux userspace */
#include <inttypes.h>
#elif defined(WIN32)                         /* Windows kernel & userspace */
typedef unsigned __int64 uint64_t;
typedef unsigned __int32 uint32_t;
typedef unsigned __int16 uint16_t;
typedef unsigned __int8  uint8_t;
typedef __int64  int64_t;
typedef __int32  int32_t;
typedef __int16  int16_t;
typedef __int8   int8_t;
#endif

#define DSD_TAG "dsd: "
#define DSD_DEVICE_PREFIX "dsd"
#define DSD_BUS_DEVICE_NAME "dsdbus"

/* Device-specific ioctl codes */
#ifdef linux
#define DSD_IOCTL_BASE  0xD5  /* FIXME: Register this */
#define DSD_BUS_IOCTL_CREATE_DEVICE _IOW( DSD_IOCTL_BASE, 1, struct dsd_bus_ioctl_create_device )
#elif defined(WIN32)
#define DSD_BUS_IOCTL_CREATE_DEVICE CTL_CODE( FILE_DEVICE_BUS_EXTENDER, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS )

#include <initguid.h>
// {77888ce0-e8f9-11db-9707-00e08161165f}
DEFINE_GUID( GUID_DEVCLASS_DISPERSED_STORAGE, 
	0x77888ce0, 0xe8f9, 0x11db, 
	0x97, 0x7, 0x0, 0xe0, 0x81, 0x61, 0x16, 0x5f );

// {35894489-e93a-11db-9707-00e08161165f}
DEFINE_GUID( GUID_DEVINTERFACE_BUSENUM_DISPERSED_STORAGE, 
	0x35894489, 0xe93a, 0x11db, 
	0x97, 0x7, 0x0, 0xe0, 0x81, 0x61, 0x16, 0x5f );

// {54b9e7ea-e93a-11db-9707-00e08161165f}
DEFINE_GUID( GUID_DEVINTERFACE_DISPERSED_STORAGE, 
	0x54b9e7ea, 0xe93a, 0x11db, 
	0x97, 0x7, 0x0, 0xe0, 0x81, 0x61, 0x16, 0x5f );

#endif

#pragma pack(push)
#pragma pack(1)

/* ioctl structs */
struct dsd_bus_ioctl_create_device
{
   /* Device parameters */
   uint64_t sectors;       /* Number of sectors */
   uint16_t sector_size;   /* Sector size in bytes */

   /* Connection parameters */
   uint32_t ip_addr;       /* IPv4 address */
   uint16_t port;          /* Port number */
};

struct dsd_bus_ioctl_create_device_rsp
{
   int8_t status;          /* Status */
   char device_name[64];   /* Device name (eg. /dev/dsd0) */
};


/** 
 * Message structs 
 * NOTE: Since this mini-protocol is always used over the loopback
 *       interface, no byte-swapping is done on message fields
 */
#define DSD_MAGIC 0xD5
struct dsd_msg_header
{
   uint8_t  magic;         /* Magic number */
   uint8_t  msg_type;      /* DSD_MSG_* */
   uint32_t len;           /* Payload length */
};

#define DSD_MSG_REMOVE_DEVICE     0xA0
struct dsd_msg_remove_device
{
   int32_t device_num;     /* FIXME: Device number */
};

#define DSD_MSG_REMOVE_DEVICE_RSP 0xA1
struct dsd_msg_remove_device_rsp
{
   int8_t status;          /* 0 for success, -1 for failure */
};

#define DSD_MSG_READ_SECTORS      0xA2
struct dsd_msg_read_sectors
{
   int32_t  request_tag;   /* Tagged cmd queueing */
   uint64_t first_sector;  /* First sector to read */
   uint8_t  num_sectors;   /* Number of sectors to read */
};

#define DSD_MSG_READ_SECTORS_RSP  0xA3
struct dsd_msg_read_sectors_rsp 
{
   int32_t  request_tag;   /* Tagged cmd queueing */
   uint64_t bytes;         /* Bytes read */
   uint8_t  data[1];       /* Read data */
};

#define DSD_MSG_WRITE_SECTORS     0xA4
struct dsd_msg_write_sectors
{
   int32_t  request_tag;   /* Tagged cmd queueing */
   uint64_t first_sector;  /* First sector to write */
   uint8_t  num_sectors;   /* Number of sectors to write */
   uint8_t  data[1];       /* Write data */
};

#define DSD_MSG_WRITE_SECTORS_RSP 0xA5
struct dsd_msg_write_sectors_rsp
{
   int32_t request_tag;    /* Tagged cmd queueing */
   int8_t  status;         /* 0 for success */
};

#pragma pack(pop)

#endif

