/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpam;

import net.sf.jpam.PamReturnValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Pam {
    private static final Log LOG = LogFactory.getLog((String)Pam.class.getName());
    private static final String JPAM_SHARED_LIBRARY_NAME = "jpam";
    private String serviceName;
    public static final String DEFAULT_SERVICE_NAME = "net-sf-jpam";

    public Pam() {
        this(DEFAULT_SERVICE_NAME);
    }

    public Pam(String serviceName) throws NullPointerException, IllegalArgumentException {
        if (serviceName == null) {
            throw new NullPointerException("Service name is null");
        }
        if (serviceName.length() == 0) {
            throw new IllegalArgumentException("Service name is empty");
        }
        this.serviceName = serviceName;
    }

    native boolean isSharedLibraryWorking();

    private void callback() {
    }

    public boolean authenticateSuccessful(String username, String credentials) {
        PamReturnValue success = PamReturnValue.PAM_SUCCESS;
        PamReturnValue actual = this.authenticate(username, credentials);
        return actual.equals(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PamReturnValue authenticate(String username, String credentials) throws NullPointerException {
        boolean debug = LOG.isDebugEnabled();
        LOG.debug((Object)"Debug mode active.");
        if (this.serviceName == null) {
            throw new NullPointerException("Service name is null");
        }
        if (username == null) {
            throw new NullPointerException("User name is null");
        }
        if (credentials == null) {
            throw new NullPointerException("Credentials are null");
        }
        Class<Pam> clazz = Pam.class;
        synchronized (Pam.class) {
            PamReturnValue pamReturnValue = PamReturnValue.fromId(this.authenticate(this.serviceName, username, credentials, debug));
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return pamReturnValue;
        }
    }

    public static void main(String[] args) {
        Pam pam = new Pam();
        PamReturnValue pamReturnValue = pam.authenticate(args[0], args[1]);
        System.out.println("Response: " + pamReturnValue);
    }

    private native int authenticate(String var1, String var2, String var3, boolean var4);

    public static String getLibraryName() {
        return System.mapLibraryName(JPAM_SHARED_LIBRARY_NAME);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    static {
        System.loadLibrary(JPAM_SHARED_LIBRARY_NAME);
    }
}

