/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoAcceptorConfig;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;

public class VmPipeSessionCrossCommunicationTest
extends TestCase {
    public void testOneSessionTalkingBackAndForthDoesNotDeadlock() throws Exception {
        final VmPipeAddress address = new VmPipeAddress(1);
        final VmPipeConnector connector = new VmPipeConnector();
        final AtomicReference<IoSession> c1 = new AtomicReference<IoSession>();
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch messageCount = new CountDownLatch(2);
        VmPipeAcceptor acceptor = new VmPipeAcceptor();
        acceptor.bind(address, new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + ": " + message);
                if ("start".equals(message)) {
                    session.write("open new");
                } else if ("re-use c1".equals(message)) {
                    session.write("tell me something on c1 now");
                } else if (((String)message).startsWith("please don't deadlock")) {
                    messageCount.countDown();
                } else {
                    VmPipeSessionCrossCommunicationTest.fail((String)("unexpected message received " + message));
                }
            }
        });
        connector.getDefaultConfig().setThreadModel(ThreadModel.MANUAL);
        ConnectFuture future = connector.connect(address, new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                System.out.println(String.valueOf(Thread.currentThread().getName()) + ": " + message);
                if ("open new".equals(message)) {
                    System.out.println("opening c2 from " + Thread.currentThread().getName());
                    ConnectFuture c2Future = connector.connect(address, new IoHandlerAdapter(){

                        public void sessionOpened(IoSession session) throws Exception {
                            session.write("re-use c1");
                        }

                        public void messageReceived(IoSession session, Object message) throws Exception {
                            System.out.println(String.valueOf(Thread.currentThread().getName()) + ": " + message);
                            if ("tell me something on c1 now".equals(message)) {
                                latch.countDown();
                                ((IoSession)c1.get()).write("please don't deadlock via c1");
                            } else {
                                VmPipeSessionCrossCommunicationTest.fail((String)("unexpected message received " + message));
                            }
                        }
                    });
                    c2Future.join();
                    latch.await();
                    c2Future.getSession().write("please don't deadlock via c2");
                } else {
                    VmPipeSessionCrossCommunicationTest.fail((String)("unexpeced message received " + message));
                }
            }
        });
        future.join();
        c1.set(future.getSession());
        ((IoSession)c1.get()).write("start");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        while (!messageCount.await(100L, TimeUnit.MILLISECONDS)) {
            ThreadInfo info;
            ThreadInfo[] infos;
            long[] threads = threadMXBean.findMonitorDeadlockedThreads();
            if (threads == null) continue;
            StringBuffer sb = new StringBuffer(256);
            ThreadInfo[] threadInfoArray = infos = threadMXBean.getThreadInfo(threads, Integer.MAX_VALUE);
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                info = threadInfoArray[n2];
                sb.append(info.getThreadName()).append(" blocked on ").append(info.getLockName()).append(" owned by ").append(info.getLockOwnerName()).append("\n");
                ++n2;
            }
            threadInfoArray = infos;
            n = infos.length;
            n2 = 0;
            while (n2 < n) {
                info = threadInfoArray[n2];
                sb.append("\nStack for ").append(info.getThreadName()).append("\n");
                StackTraceElement[] stackTraceElementArray = info.getStackTrace();
                int n3 = stackTraceElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    StackTraceElement element = stackTraceElementArray[n4];
                    sb.append("\t").append(element).append("\n");
                    ++n4;
                }
                ++n2;
            }
            VmPipeSessionCrossCommunicationTest.fail((String)("deadlocked! \n" + sb));
        }
        ((IoAcceptorConfig)acceptor.getDefaultConfig()).setDisconnectOnUnbind(false);
        acceptor.unbindAll();
    }
}

