/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;

public class SocketSessionConfigImpl
extends BaseIoSessionConfig
implements SocketSessionConfig {
    private static Map<InetSocketAddress, InetAddress> TEST_ADDRESSES = new LinkedHashMap<InetSocketAddress, InetAddress>();
    private static boolean SET_RECEIVE_BUFFER_SIZE_AVAILABLE = false;
    private static boolean SET_SEND_BUFFER_SIZE_AVAILABLE = false;
    private static boolean GET_TRAFFIC_CLASS_AVAILABLE = false;
    private static boolean SET_TRAFFIC_CLASS_AVAILABLE = false;
    private static boolean DEFAULT_REUSE_ADDRESS = false;
    private static int DEFAULT_RECEIVE_BUFFER_SIZE = 1024;
    private static int DEFAULT_SEND_BUFFER_SIZE = 1024;
    private static int DEFAULT_TRAFFIC_CLASS = 0;
    private static boolean DEFAULT_KEEP_ALIVE = false;
    private static boolean DEFAULT_OOB_INLINE = false;
    private static int DEFAULT_SO_LINGER = -1;
    private static boolean DEFAULT_TCP_NO_DELAY = false;
    private boolean reuseAddress = DEFAULT_REUSE_ADDRESS;
    private int receiveBufferSize = DEFAULT_RECEIVE_BUFFER_SIZE;
    private int sendBufferSize = DEFAULT_SEND_BUFFER_SIZE;
    private int trafficClass = DEFAULT_TRAFFIC_CLASS;
    private boolean keepAlive = DEFAULT_KEEP_ALIVE;
    private boolean oobInline = DEFAULT_OOB_INLINE;
    private int soLinger = DEFAULT_SO_LINGER;
    private boolean tcpNoDelay = DEFAULT_TCP_NO_DELAY;

    static {
        SocketSessionConfigImpl.initializeTestAddresses();
        boolean success = false;
        for (Map.Entry<InetSocketAddress, InetAddress> e : TEST_ADDRESSES.entrySet()) {
            success = SocketSessionConfigImpl.initializeDefaultSocketParameters(e.getKey(), e.getValue());
            if (success) break;
        }
        if (!success) {
            SocketSessionConfigImpl.initializeFallbackDefaultSocketParameters();
        }
    }

    private static void initializeFallbackDefaultSocketParameters() {
        Socket unconnectedSocket = new Socket();
        try {
            SocketSessionConfigImpl.initializeDefaultSocketParameters(unconnectedSocket);
        }
        catch (SocketException se) {
            ExceptionMonitor.getInstance().exceptionCaught(se);
            try {
                unconnectedSocket.close();
            }
            catch (IOException ioe) {
                ExceptionMonitor.getInstance().exceptionCaught(ioe);
            }
        }
    }

    private static void initializeTestAddresses() {
        try {
            byte[] byArray = new byte[16];
            byArray[15] = 1;
            TEST_ADDRESSES.put(new InetSocketAddress(0), InetAddress.getByAddress(byArray));
            byte[] byArray2 = new byte[4];
            byArray2[0] = 127;
            byArray2[3] = 1;
            TEST_ADDRESSES.put(new InetSocketAddress(0), InetAddress.getByAddress(byArray2));
        }
        catch (UnknownHostException e) {
            ExceptionMonitor.getInstance().exceptionCaught(e);
        }
    }

    private static boolean initializeDefaultSocketParameters(InetSocketAddress bindAddress, InetAddress connectAddress) {
        ServerSocket ss = null;
        Socket socket = null;
        try {
            ss = new ServerSocket();
            ss.bind(bindAddress);
            socket = new Socket();
            socket.connect(new InetSocketAddress(connectAddress, ss.getLocalPort()), 10000);
            SocketSessionConfigImpl.initializeDefaultSocketParameters(socket);
            return true;
        }
        catch (Exception e) {
            return false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
    }

    private static void initializeDefaultSocketParameters(Socket socket) throws SocketException {
        DEFAULT_REUSE_ADDRESS = socket.getReuseAddress();
        DEFAULT_RECEIVE_BUFFER_SIZE = socket.getReceiveBufferSize();
        DEFAULT_SEND_BUFFER_SIZE = socket.getSendBufferSize();
        DEFAULT_KEEP_ALIVE = socket.getKeepAlive();
        DEFAULT_OOB_INLINE = socket.getOOBInline();
        DEFAULT_SO_LINGER = socket.getSoLinger();
        DEFAULT_TCP_NO_DELAY = socket.getTcpNoDelay();
        try {
            socket.setReceiveBufferSize(DEFAULT_RECEIVE_BUFFER_SIZE);
            SET_RECEIVE_BUFFER_SIZE_AVAILABLE = true;
        }
        catch (SocketException e) {
            SET_RECEIVE_BUFFER_SIZE_AVAILABLE = false;
        }
        try {
            socket.setSendBufferSize(DEFAULT_SEND_BUFFER_SIZE);
            SET_SEND_BUFFER_SIZE_AVAILABLE = true;
        }
        catch (SocketException e) {
            SET_SEND_BUFFER_SIZE_AVAILABLE = false;
        }
        try {
            DEFAULT_TRAFFIC_CLASS = socket.getTrafficClass();
            GET_TRAFFIC_CLASS_AVAILABLE = true;
        }
        catch (SocketException e) {
            GET_TRAFFIC_CLASS_AVAILABLE = false;
            DEFAULT_TRAFFIC_CLASS = 0;
        }
    }

    public static boolean isSetReceiveBufferSizeAvailable() {
        return SET_RECEIVE_BUFFER_SIZE_AVAILABLE;
    }

    public static boolean isSetSendBufferSizeAvailable() {
        return SET_SEND_BUFFER_SIZE_AVAILABLE;
    }

    public static boolean isGetTrafficClassAvailable() {
        return GET_TRAFFIC_CLASS_AVAILABLE;
    }

    public static boolean isSetTrafficClassAvailable() {
        return SET_TRAFFIC_CLASS_AVAILABLE;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isOobInline() {
        return this.oobInline;
    }

    public void setOobInline(boolean oobInline) {
        this.oobInline = oobInline;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }
}

