/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.InetSocketAddress;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.DatagramConnector;
import org.apache.mina.util.AvailablePortFinder;

public class DatagramConfigTest
extends TestCase {
    private final IoAcceptor acceptor = new DatagramAcceptor();
    private final IoConnector connector = new DatagramConnector();
    private String result;

    protected void setUp() throws Exception {
        this.result = "";
    }

    public void testAcceptorFilterChain() throws Exception {
        int port = AvailablePortFinder.getNextAvailable(1024);
        DatagramAcceptorConfig expectedConfig = new DatagramAcceptorConfig();
        MockFilter mockFilter = new MockFilter();
        MockHandler mockHandler = new MockHandler();
        expectedConfig.getFilterChain().addLast("mock", mockFilter);
        this.acceptor.bind(new InetSocketAddress(port), mockHandler, expectedConfig);
        try {
            ConnectFuture future = this.connector.connect(new InetSocketAddress("localhost", port), new IoHandlerAdapter());
            future.join();
            WriteFuture writeFuture = future.getSession().write(ByteBuffer.allocate(16).putInt(0).flip());
            writeFuture.join();
            Assert.assertTrue((boolean)writeFuture.isWritten());
            future.getSession().close();
            int i = 0;
            while (i < 30) {
                if (this.result.length() == 2) break;
                Thread.sleep(100L);
                ++i;
            }
            Assert.assertEquals((String)"FH", (String)this.result);
        }
        finally {
            this.acceptor.unbind(new InetSocketAddress(port));
        }
    }

    private class MockFilter
    extends IoFilterAdapter {
        private MockFilter() {
        }

        public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
            DatagramConfigTest datagramConfigTest = DatagramConfigTest.this;
            datagramConfigTest.result = String.valueOf(datagramConfigTest.result) + "F";
            nextFilter.messageReceived(session, message);
        }
    }

    private class MockHandler
    extends IoHandlerAdapter {
        private MockHandler() {
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            DatagramConfigTest datagramConfigTest = DatagramConfigTest.this;
            datagramConfigTest.result = String.valueOf(datagramConfigTest.result) + "H";
        }
    }
}

