/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport;

import java.net.SocketAddress;
import junit.framework.TestCase;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.TransportType;
import org.apache.mina.util.AvailablePortFinder;

public abstract class AbstractTrafficControlTest
extends TestCase {
    protected int port = 0;
    protected IoAcceptor acceptor;
    protected TransportType transportType;

    public AbstractTrafficControlTest(IoAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.port = AvailablePortFinder.getNextAvailable();
        this.acceptor.bind(this.createServerSocketAddress(this.port), new ServerIoHandler());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.acceptor.unbind(this.createServerSocketAddress(this.port));
    }

    protected abstract ConnectFuture connect(int var1, IoHandler var2) throws Exception;

    protected abstract SocketAddress createServerSocketAddress(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSuspendResumeReadWrite() throws Exception {
        Object lock;
        ConnectFuture future = this.connect(this.port, new ClientIoHandler());
        future.join();
        IoSession session = future.getSession();
        while (session.getAttribute("lock") == null) {
            Thread.yield();
        }
        Object object = lock = session.getAttribute("lock");
        synchronized (object) {
            this.write(session, "1");
            AbstractTrafficControlTest.assertEquals((int)49, (int)this.read(session));
            AbstractTrafficControlTest.assertEquals((String)"1", (String)this.getReceived(session));
            AbstractTrafficControlTest.assertEquals((String)"1", (String)this.getSent(session));
            session.suspendRead();
            this.write(session, "2");
            AbstractTrafficControlTest.assertFalse((boolean)this.canRead(session));
            AbstractTrafficControlTest.assertEquals((String)"1", (String)this.getReceived(session));
            AbstractTrafficControlTest.assertEquals((String)"12", (String)this.getSent(session));
            session.suspendWrite();
            this.write(session, "3");
            AbstractTrafficControlTest.assertFalse((boolean)this.canRead(session));
            AbstractTrafficControlTest.assertEquals((String)"1", (String)this.getReceived(session));
            AbstractTrafficControlTest.assertEquals((String)"12", (String)this.getSent(session));
            session.resumeRead();
            this.write(session, "4");
            AbstractTrafficControlTest.assertEquals((int)50, (int)this.read(session));
            AbstractTrafficControlTest.assertEquals((String)"12", (String)this.getReceived(session));
            AbstractTrafficControlTest.assertEquals((String)"12", (String)this.getSent(session));
            session.resumeWrite();
            AbstractTrafficControlTest.assertEquals((int)51, (int)this.read(session));
            AbstractTrafficControlTest.assertEquals((int)52, (int)this.read(session));
            this.write(session, "5");
            AbstractTrafficControlTest.assertEquals((int)53, (int)this.read(session));
            AbstractTrafficControlTest.assertEquals((String)"12345", (String)this.getReceived(session));
            AbstractTrafficControlTest.assertEquals((String)"12345", (String)this.getSent(session));
            session.suspendWrite();
            this.write(session, "6");
            AbstractTrafficControlTest.assertFalse((boolean)this.canRead(session));
            AbstractTrafficControlTest.assertEquals((String)"12345", (String)this.getReceived(session));
            AbstractTrafficControlTest.assertEquals((String)"12345", (String)this.getSent(session));
            session.suspendRead();
            session.resumeWrite();
            this.write(session, "7");
            AbstractTrafficControlTest.assertFalse((boolean)this.canRead(session));
            AbstractTrafficControlTest.assertEquals((String)"12345", (String)this.getReceived(session));
            AbstractTrafficControlTest.assertEquals((String)"1234567", (String)this.getSent(session));
            session.resumeRead();
            AbstractTrafficControlTest.assertEquals((int)54, (int)this.read(session));
            AbstractTrafficControlTest.assertEquals((int)55, (int)this.read(session));
            AbstractTrafficControlTest.assertEquals((String)"1234567", (String)this.getReceived(session));
            AbstractTrafficControlTest.assertEquals((String)"1234567", (String)this.getSent(session));
        }
        session.close().join();
    }

    private void write(IoSession session, String s) throws Exception {
        session.write(ByteBuffer.wrap(s.getBytes("ASCII")));
    }

    private int read(IoSession session) throws Exception {
        int pos = (Integer)session.getAttribute("pos");
        int i = 0;
        while (i < 10 && pos == this.getReceived(session).length()) {
            Object lock = session.getAttribute("lock");
            lock.wait(200L);
            ++i;
        }
        session.setAttribute("pos", new Integer(pos + 1));
        return this.getReceived(session).charAt(pos);
    }

    private boolean canRead(IoSession session) throws Exception {
        int pos = (Integer)session.getAttribute("pos");
        Object lock = session.getAttribute("lock");
        lock.wait(250L);
        String received = this.getReceived(session);
        return pos < received.length();
    }

    private String getReceived(IoSession session) throws Exception {
        return session.getAttribute("received").toString();
    }

    private String getSent(IoSession session) throws Exception {
        return session.getAttribute("sent").toString();
    }

    public static class ClientIoHandler
    extends IoHandlerAdapter {
        public void sessionCreated(IoSession session) throws Exception {
            super.sessionCreated(session);
            session.setAttribute("pos", new Integer(0));
            session.setAttribute("received", new StringBuffer());
            session.setAttribute("sent", new StringBuffer());
            session.setAttribute("lock", new Object());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(IoSession session, Object message) throws Exception {
            Object lock;
            ByteBuffer buffer = (ByteBuffer)message;
            byte[] data = new byte[buffer.remaining()];
            buffer.get(data);
            Object object = lock = session.getAttribute("lock");
            synchronized (object) {
                StringBuffer sb = (StringBuffer)session.getAttribute("received");
                sb.append(new String(data, "ASCII"));
                lock.notifyAll();
            }
        }

        public void messageSent(IoSession session, Object message) throws Exception {
            ByteBuffer buffer = (ByteBuffer)message;
            buffer.rewind();
            byte[] data = new byte[buffer.remaining()];
            buffer.get(data);
            StringBuffer sb = (StringBuffer)session.getAttribute("sent");
            sb.append(new String(data, "ASCII"));
        }
    }

    private static class ServerIoHandler
    extends IoHandlerAdapter {
        private ServerIoHandler() {
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            ByteBuffer rb = (ByteBuffer)message;
            ByteBuffer wb = ByteBuffer.allocate(rb.remaining());
            wb.put(rb);
            wb.flip();
            session.write(wb);
        }
    }
}

