/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport;

import java.net.InetSocketAddress;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.util.AvailablePortFinder;

public abstract class AbstractConnectorTest
extends TestCase {
    protected abstract IoAcceptor createAcceptor();

    protected abstract IoConnector createConnector();

    public void testConnectFutureSuccessTiming() throws Exception {
        int port = AvailablePortFinder.getNextAvailable(1025);
        IoAcceptor acceptor = this.createAcceptor();
        acceptor.bind(new InetSocketAddress(port), new IoHandlerAdapter());
        try {
            final StringBuffer buf = new StringBuffer();
            IoConnector connector = this.createConnector();
            ConnectFuture future = connector.connect(new InetSocketAddress("localhost", port), new IoHandlerAdapter(){

                public void sessionCreated(IoSession session) {
                    buf.append("1");
                }

                public void sessionOpened(IoSession session) {
                    buf.append("2");
                }

                public void exceptionCaught(IoSession session, Throwable cause) {
                    buf.append("X");
                }
            });
            future.join();
            buf.append("3");
            future.getSession().close();
            Assert.assertEquals((String)"123", (String)buf.toString());
        }
        finally {
            acceptor.unbind(new InetSocketAddress(port));
        }
    }

    public void testConnectFutureFailureTiming() throws Exception {
        int port = AvailablePortFinder.getNextAvailable(1025);
        final StringBuffer buf = new StringBuffer();
        IoConnector connector = this.createConnector();
        ConnectFuture future = connector.connect(new InetSocketAddress("localhost", port), new IoHandlerAdapter(){

            public void sessionCreated(IoSession session) {
                buf.append("X");
            }

            public void sessionOpened(IoSession session) {
                buf.append("Y");
            }

            public void exceptionCaught(IoSession session, Throwable cause) {
                buf.append("Z");
            }
        });
        future.join();
        buf.append("1");
        try {
            future.getSession().close();
            AbstractConnectorTest.fail();
        }
        catch (RuntimeIOException runtimeIOException) {
            // empty catch block
        }
        Assert.assertEquals((String)"1", (String)buf.toString());
    }
}

