/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.handler.demux;

import junit.framework.TestCase;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.demux.DemuxingIoHandler;
import org.apache.mina.handler.demux.MessageHandler;
import org.easymock.MockControl;

public class DemuxingIoHandlerTest
extends TestCase {
    MockControl mockHandler1;
    MockControl mockHandler2;
    MockControl mockHandler3;
    MessageHandler handler1;
    MessageHandler handler2;
    MessageHandler handler3;
    IoSession session;
    Object[] msg;

    protected void setUp() throws Exception {
        super.setUp();
        this.msg = new Object[9];
        this.msg[0] = new C1();
        this.msg[1] = new C2();
        this.msg[2] = new C3();
        this.msg[3] = new C1();
        this.msg[4] = new C2();
        this.msg[5] = new C3();
        this.msg[6] = new C1();
        this.msg[7] = new C2();
        this.msg[8] = new C3();
        this.mockHandler1 = MockControl.createControl(MessageHandler.class);
        this.mockHandler2 = MockControl.createControl(MessageHandler.class);
        this.mockHandler3 = MockControl.createControl(MessageHandler.class);
        this.handler1 = (MessageHandler)this.mockHandler1.getMock();
        this.handler2 = (MessageHandler)this.mockHandler2.getMock();
        this.handler3 = (MessageHandler)this.mockHandler3.getMock();
        this.session = (IoSession)MockControl.createControl(IoSession.class).getMock();
    }

    public void testFindHandlerByClass() throws Exception {
        this.handler1.messageReceived(this.session, this.msg[0]);
        this.handler1.messageReceived(this.session, this.msg[1]);
        this.handler1.messageReceived(this.session, this.msg[2]);
        this.handler1.messageReceived(this.session, this.msg[3]);
        this.handler2.messageReceived(this.session, this.msg[4]);
        this.handler2.messageReceived(this.session, this.msg[5]);
        this.handler1.messageReceived(this.session, this.msg[6]);
        this.handler2.messageReceived(this.session, this.msg[7]);
        this.handler3.messageReceived(this.session, this.msg[8]);
        this.mockHandler1.replay();
        this.mockHandler2.replay();
        this.mockHandler3.replay();
        DemuxingIoHandler ioHandler = new DemuxingIoHandler();
        ioHandler.addMessageHandler(C1.class, (MessageHandler)this.mockHandler1.getMock());
        ioHandler.messageReceived(this.session, this.msg[0]);
        ioHandler.messageReceived(this.session, this.msg[1]);
        ioHandler.messageReceived(this.session, this.msg[2]);
        ioHandler.addMessageHandler(C2.class, (MessageHandler)this.mockHandler2.getMock());
        ioHandler.messageReceived(this.session, this.msg[3]);
        ioHandler.messageReceived(this.session, this.msg[4]);
        ioHandler.messageReceived(this.session, this.msg[5]);
        ioHandler.addMessageHandler(C3.class, (MessageHandler)this.mockHandler3.getMock());
        ioHandler.messageReceived(this.session, this.msg[6]);
        ioHandler.messageReceived(this.session, this.msg[7]);
        ioHandler.messageReceived(this.session, this.msg[8]);
        this.mockHandler1.verify();
        this.mockHandler2.verify();
        this.mockHandler3.verify();
    }

    public void testFindHandlerByInterface() throws Exception {
        this.handler1.messageReceived(this.session, this.msg[0]);
        this.handler1.messageReceived(this.session, this.msg[1]);
        this.handler1.messageReceived(this.session, this.msg[2]);
        this.handler1.messageReceived(this.session, this.msg[3]);
        this.handler2.messageReceived(this.session, this.msg[4]);
        this.handler1.messageReceived(this.session, this.msg[5]);
        this.handler3.messageReceived(this.session, this.msg[6]);
        this.handler2.messageReceived(this.session, this.msg[7]);
        this.handler3.messageReceived(this.session, this.msg[8]);
        this.mockHandler1.replay();
        this.mockHandler2.replay();
        this.mockHandler3.replay();
        DemuxingIoHandler ioHandler = new DemuxingIoHandler();
        ioHandler.addMessageHandler(I4.class, (MessageHandler)this.mockHandler1.getMock());
        ioHandler.messageReceived(this.session, this.msg[0]);
        ioHandler.messageReceived(this.session, this.msg[1]);
        ioHandler.messageReceived(this.session, this.msg[2]);
        ioHandler.addMessageHandler(I6.class, (MessageHandler)this.mockHandler2.getMock());
        ioHandler.messageReceived(this.session, this.msg[3]);
        ioHandler.messageReceived(this.session, this.msg[4]);
        ioHandler.messageReceived(this.session, this.msg[5]);
        ioHandler.addMessageHandler(I3.class, (MessageHandler)this.mockHandler3.getMock());
        ioHandler.messageReceived(this.session, this.msg[6]);
        ioHandler.messageReceived(this.session, this.msg[7]);
        ioHandler.messageReceived(this.session, this.msg[8]);
        this.mockHandler1.verify();
        this.mockHandler2.verify();
        this.mockHandler3.verify();
    }

    public static class C1
    implements I1,
    I2,
    I4 {
    }

    public static class C2
    extends C1
    implements I5,
    I6 {
    }

    public static class C3
    extends C2
    implements I7,
    I9 {
    }

    public static interface I1 {
    }

    public static interface I2
    extends I3 {
    }

    public static interface I3 {
    }

    public static interface I4 {
    }

    public static interface I5 {
    }

    public static interface I6 {
    }

    public static interface I7
    extends I8 {
    }

    public static interface I8 {
    }

    public static interface I9
    extends I3,
    I4 {
    }
}

