/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.textline;

import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.LinkedList;
import java.util.Queue;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.mina.common.BufferDataException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.filter.codec.textline.TextLineDecoder;

public class TextLineDecoderTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(TextLineDecoderTest.class);
    }

    public void testNormalDecode() throws Exception {
        TextLineDecoder decoder = new TextLineDecoder(Charset.forName("UTF-8"), LineDelimiter.WINDOWS);
        CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
        DummySession session = new DummySession();
        TestDecoderOutput out = new TestDecoderOutput();
        ByteBuffer in = ByteBuffer.allocate(16);
        in.putString("ABC\r\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)1, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"ABC", (Object)out.getMessageQueue().poll());
        in.clear();
        in.putString("DEF", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear();
        in.putString("GHI\r\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)1, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"DEFGHI", (Object)out.getMessageQueue().poll());
        in.clear();
        in.putString("JKL\r\nMNO\r\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)2, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"JKL", (Object)out.getMessageQueue().poll());
        Assert.assertEquals((Object)"MNO", (Object)out.getMessageQueue().poll());
        decoder = new TextLineDecoder(Charset.forName("UTF-8"), new LineDelimiter("\n\n\n"));
        in.clear();
        in.putString("PQR\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear();
        in.putString("\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear();
        in.putString("\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)1, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"PQR", (Object)out.getMessageQueue().poll());
        decoder = new TextLineDecoder(Charset.forName("UTF-8"), new LineDelimiter("\n\n\n"));
        in.clear();
        in.putString("PQR\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear();
        in.putString("\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear();
        in.putString("\nSTU\n\n\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)2, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"PQR", (Object)out.getMessageQueue().poll());
        Assert.assertEquals((Object)"STU", (Object)out.getMessageQueue().poll());
        decoder = new TextLineDecoder(Charset.forName("UTF-8"), new LineDelimiter("\n\n\n"));
        in.clear();
        in.putString("PQR\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear();
        in.putString("X\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear();
        in.putString("\n\nSTU\n\n\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)2, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"PQR\nX", (Object)out.getMessageQueue().poll());
        Assert.assertEquals((Object)"STU", (Object)out.getMessageQueue().poll());
    }

    public void testAutoDecode() throws Exception {
        TextLineDecoder decoder = new TextLineDecoder(Charset.forName("UTF-8"), LineDelimiter.AUTO);
        CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
        DummySession session = new DummySession();
        TestDecoderOutput out = new TestDecoderOutput();
        ByteBuffer in = ByteBuffer.allocate(16);
        in.putString("ABC\r\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)1, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"ABC", (Object)out.getMessageQueue().poll());
        in.clear();
        in.putString("DEF", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear();
        in.putString("GHI\r\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)1, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"DEFGHI", (Object)out.getMessageQueue().poll());
        in.clear();
        in.putString("JKL\r\nMNO\r\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)2, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"JKL", (Object)out.getMessageQueue().poll());
        Assert.assertEquals((Object)"MNO", (Object)out.getMessageQueue().poll());
        in.clear();
        in.putString("\n\n\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)3, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"", (Object)out.getMessageQueue().poll());
        Assert.assertEquals((Object)"", (Object)out.getMessageQueue().poll());
        Assert.assertEquals((Object)"", (Object)out.getMessageQueue().poll());
        in.clear();
        in.putString("PQR\r", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear();
        in.putString("\r", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear();
        in.putString("\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)1, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"PQR", (Object)out.getMessageQueue().poll());
        in.clear();
        in.putString("PQR\r", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear();
        in.putString("\r", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear();
        in.putString("\nSTU\r\r\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)2, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"PQR", (Object)out.getMessageQueue().poll());
        Assert.assertEquals((Object)"STU", (Object)out.getMessageQueue().poll());
        in.clear();
        in.putString("PQR\r", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear();
        in.putString("X\r", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear();
        in.putString("\r\nSTU\r\r\n", encoder);
        in.flip();
        decoder.decode(session, in, out);
        Assert.assertEquals((int)2, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"PQR\rX", (Object)out.getMessageQueue().poll());
        Assert.assertEquals((Object)"STU", (Object)out.getMessageQueue().poll());
    }

    public void testOverflow() throws Exception {
        TextLineDecoder decoder = new TextLineDecoder(Charset.forName("UTF-8"), LineDelimiter.AUTO);
        decoder.setMaxLineLength(3);
        CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
        DummySession session = new DummySession();
        TestDecoderOutput out = new TestDecoderOutput();
        ByteBuffer in = ByteBuffer.allocate(16);
        in.putString("A", encoder).flip().mark();
        decoder.decode(session, in.reset().mark(), out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        decoder.decode(session, in.reset().mark(), out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        decoder.decode(session, in.reset().mark(), out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        decoder.decode(session, in.reset().mark(), out);
        Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
        in.clear().putString("A\r\nB\r\n", encoder).flip();
        try {
            decoder.decode(session, in, out);
            Assert.fail();
        }
        catch (BufferDataException bufferDataException) {
            // empty catch block
        }
        decoder.decode(session, in, out);
        Assert.assertEquals((int)1, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"B", (Object)out.getMessageQueue().poll());
        long oldFreeMemory = Runtime.getRuntime().freeMemory();
        in = ByteBuffer.allocate(0x1000000).mark();
        int i = 0;
        while (i < 10) {
            decoder.decode(session, in.reset().mark(), out);
            Assert.assertEquals((int)0, (int)out.getMessageQueue().size());
            Assert.assertTrue((Runtime.getRuntime().freeMemory() - oldFreeMemory < 0x100000L ? 1 : 0) != 0);
            ++i;
        }
        in.clear().putString("C\r\nD\r\n", encoder).flip();
        try {
            decoder.decode(session, in, out);
            Assert.fail();
        }
        catch (BufferDataException bufferDataException) {
            // empty catch block
        }
        decoder.decode(session, in, out);
        Assert.assertEquals((int)1, (int)out.getMessageQueue().size());
        Assert.assertEquals((Object)"D", (Object)out.getMessageQueue().poll());
        Assert.assertTrue((Runtime.getRuntime().freeMemory() - oldFreeMemory < 0x100000L ? 1 : 0) != 0);
    }

    private static class DummySession
    extends BaseIoSession {
        private DummySession() {
        }

        protected void updateTrafficMask() {
        }

        public IoService getService() {
            return null;
        }

        public IoServiceConfig getServiceConfig() {
            return null;
        }

        public IoHandler getHandler() {
            return null;
        }

        public IoFilterChain getFilterChain() {
            return null;
        }

        public TransportType getTransportType() {
            return null;
        }

        public SocketAddress getRemoteAddress() {
            return null;
        }

        public SocketAddress getLocalAddress() {
            return null;
        }

        public int getScheduledWriteRequests() {
            return 0;
        }

        public IoSessionConfig getConfig() {
            return null;
        }

        public SocketAddress getServiceAddress() {
            return null;
        }

        public int getScheduledWriteBytes() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestDecoderOutput
    implements ProtocolDecoderOutput {
        private Queue<Object> messageQueue = new LinkedList<Object>();

        private TestDecoderOutput() {
        }

        @Override
        public void write(Object message) {
            this.messageQueue.add(message);
        }

        public Queue<Object> getMessageQueue() {
            return this.messageQueue;
        }

        @Override
        public void flush() {
        }
    }
}

