/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.serialization;

import java.io.ByteArrayOutputStream;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.serialization.ObjectSerializationDecoder;
import org.apache.mina.filter.codec.serialization.ObjectSerializationEncoder;
import org.apache.mina.filter.codec.serialization.ObjectSerializationInputStream;
import org.apache.mina.filter.codec.serialization.ObjectSerializationOutputStream;
import org.apache.mina.filter.codec.support.SimpleProtocolEncoderOutput;

public class ObjectSerializationTest
extends TestCase {
    public void testEncoder() throws Exception {
        String expected = "1234";
        MockIoSession session = new MockIoSession();
        SimpleProtocolEncoderOutput out = new SimpleProtocolEncoderOutput(){

            protected WriteFuture doFlush(ByteBuffer buf) {
                return null;
            }
        };
        ObjectSerializationEncoder encoder = new ObjectSerializationEncoder();
        encoder.encode(session, "1234", out);
        Assert.assertEquals((int)1, (int)out.getBufferQueue().size());
        ByteBuffer buf = out.getBufferQueue().poll();
        this.testDecoderAndInputStream("1234", buf);
    }

    public void testOutputStream() throws Exception {
        String expected = "1234";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectSerializationOutputStream osos = new ObjectSerializationOutputStream(baos);
        osos.writeObject("1234");
        osos.flush();
        this.testDecoderAndInputStream("1234", ByteBuffer.wrap(baos.toByteArray()));
    }

    private void testDecoderAndInputStream(String expected, ByteBuffer in) throws Exception {
        ObjectSerializationInputStream osis = new ObjectSerializationInputStream(in.duplicate().asInputStream());
        Object actual = osis.readObject();
        ObjectSerializationTest.assertEquals((Object)expected, (Object)actual);
        ObjectSerializationDecoder decoder = new ObjectSerializationDecoder();
        MockProtocolDecoderOutput decoderOut = new MockProtocolDecoderOutput();
        MockIoSession session = new MockIoSession();
        decoder.decode(session, in.duplicate(), decoderOut);
        Assert.assertEquals((Object)expected, decoderOut.result.get(0));
        Assert.assertEquals((int)1, (int)decoderOut.result.size());
    }

    private static class MockIoSession
    extends BaseIoSession {
        private MockIoSession() {
        }

        protected void updateTrafficMask() {
        }

        public IoSessionConfig getConfig() {
            return null;
        }

        public IoFilterChain getFilterChain() {
            return null;
        }

        public IoHandler getHandler() {
            return null;
        }

        public SocketAddress getLocalAddress() {
            return null;
        }

        public SocketAddress getRemoteAddress() {
            return null;
        }

        public int getScheduledWriteBytes() {
            return 0;
        }

        public int getScheduledWriteRequests() {
            return 0;
        }

        public IoService getService() {
            return null;
        }

        public SocketAddress getServiceAddress() {
            return null;
        }

        public IoServiceConfig getServiceConfig() {
            return null;
        }

        public TransportType getTransportType() {
            return null;
        }
    }

    private static class MockProtocolDecoderOutput
    implements ProtocolDecoderOutput {
        private List<Object> result = new ArrayList<Object>();

        private MockProtocolDecoderOutput() {
        }

        public void flush() {
        }

        public void write(Object message) {
            this.result.add(message);
        }
    }
}

