/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.DefaultWriteFuture;
import org.apache.mina.filter.StreamWriteFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.util.AvailablePortFinder;
import org.easymock.AbstractMatcher;
import org.easymock.ArgumentsMatcher;
import org.easymock.MockControl;

public class StreamWriteFilterTest
extends TestCase {
    MockControl mockSession;
    MockControl mockNextFilter;
    IoSession session;
    IoFilter.NextFilter nextFilter;

    protected void setUp() throws Exception {
        super.setUp();
        this.mockSession = MockControl.createControl(IoSession.class);
        this.mockNextFilter = MockControl.createControl(IoFilter.NextFilter.class);
        this.session = (IoSession)this.mockSession.getMock();
        this.nextFilter = (IoFilter.NextFilter)this.mockNextFilter.getMock();
        this.session.getAttribute(StreamWriteFilter.CURRENT_STREAM);
        this.mockSession.setReturnValue(null);
    }

    public void testWriteEmptyStream() throws Exception {
        StreamWriteFilter filter = new StreamWriteFilter();
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        IoFilter.WriteRequest writeRequest = new IoFilter.WriteRequest(stream, new DummyWriteFuture());
        this.nextFilter.messageSent(this.session, stream);
        this.mockNextFilter.replay();
        this.mockSession.replay();
        filter.filterWrite(this.nextFilter, this.session, writeRequest);
        this.mockNextFilter.verify();
        this.mockSession.verify();
        StreamWriteFilterTest.assertTrue((boolean)writeRequest.getFuture().isWritten());
    }

    public void testWriteNonStreamMessage() throws Exception {
        StreamWriteFilter filter = new StreamWriteFilter();
        Object message = new Object();
        IoFilter.WriteRequest writeRequest = new IoFilter.WriteRequest(message, new DummyWriteFuture());
        this.nextFilter.filterWrite(this.session, writeRequest);
        this.session.getAttribute(StreamWriteFilter.CURRENT_STREAM);
        this.mockSession.setReturnValue(null);
        this.nextFilter.messageSent(this.session, message);
        this.mockNextFilter.replay();
        this.mockSession.replay();
        filter.filterWrite(this.nextFilter, this.session, writeRequest);
        filter.messageSent(this.nextFilter, this.session, message);
        this.mockNextFilter.verify();
        this.mockSession.verify();
    }

    public void testWriteSingleBufferStream() throws Exception {
        StreamWriteFilter filter = new StreamWriteFilter();
        byte[] data = new byte[]{1, 2, 3, 4};
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        IoFilter.WriteRequest writeRequest = new IoFilter.WriteRequest(stream, new DummyWriteFuture());
        this.session.setAttribute(StreamWriteFilter.CURRENT_STREAM, stream);
        this.mockSession.setReturnValue(null);
        this.session.setAttribute(StreamWriteFilter.INITIAL_WRITE_FUTURE, writeRequest.getFuture());
        this.mockSession.setReturnValue(null);
        this.nextFilter.filterWrite(this.session, new IoFilter.WriteRequest(ByteBuffer.wrap(data)));
        this.mockNextFilter.setMatcher((ArgumentsMatcher)new WriteRequestMatcher());
        this.session.getAttribute(StreamWriteFilter.CURRENT_STREAM);
        this.mockSession.setReturnValue((Object)stream);
        this.session.removeAttribute(StreamWriteFilter.CURRENT_STREAM);
        this.mockSession.setReturnValue((Object)stream);
        this.session.removeAttribute(StreamWriteFilter.INITIAL_WRITE_FUTURE);
        this.mockSession.setReturnValue((Object)writeRequest.getFuture());
        this.session.removeAttribute(StreamWriteFilter.WRITE_REQUEST_QUEUE);
        this.mockSession.setReturnValue(null);
        this.nextFilter.messageSent(this.session, stream);
        this.mockNextFilter.replay();
        this.mockSession.replay();
        filter.filterWrite(this.nextFilter, this.session, writeRequest);
        filter.messageSent(this.nextFilter, this.session, data);
        this.mockNextFilter.verify();
        this.mockSession.verify();
        StreamWriteFilterTest.assertTrue((boolean)writeRequest.getFuture().isWritten());
    }

    public void testWriteSeveralBuffersStream() throws Exception {
        StreamWriteFilter filter = new StreamWriteFilter();
        filter.setWriteBufferSize(4);
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] chunk1 = new byte[]{1, 2, 3, 4};
        byte[] chunk2 = new byte[]{5, 6, 7, 8};
        byte[] chunk3 = new byte[]{9, 10};
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        IoFilter.WriteRequest writeRequest = new IoFilter.WriteRequest(stream, new DummyWriteFuture());
        this.session.setAttribute(StreamWriteFilter.CURRENT_STREAM, stream);
        this.mockSession.setReturnValue(null);
        this.session.setAttribute(StreamWriteFilter.INITIAL_WRITE_FUTURE, writeRequest.getFuture());
        this.mockSession.setReturnValue(null);
        this.nextFilter.filterWrite(this.session, new IoFilter.WriteRequest(ByteBuffer.wrap(chunk1)));
        this.mockNextFilter.setMatcher((ArgumentsMatcher)new WriteRequestMatcher());
        this.session.getAttribute(StreamWriteFilter.CURRENT_STREAM);
        this.mockSession.setReturnValue((Object)stream);
        this.nextFilter.filterWrite(this.session, new IoFilter.WriteRequest(ByteBuffer.wrap(chunk2)));
        this.session.getAttribute(StreamWriteFilter.CURRENT_STREAM);
        this.mockSession.setReturnValue((Object)stream);
        this.nextFilter.filterWrite(this.session, new IoFilter.WriteRequest(ByteBuffer.wrap(chunk3)));
        this.session.getAttribute(StreamWriteFilter.CURRENT_STREAM);
        this.mockSession.setReturnValue((Object)stream);
        this.session.removeAttribute(StreamWriteFilter.CURRENT_STREAM);
        this.mockSession.setReturnValue((Object)stream);
        this.session.removeAttribute(StreamWriteFilter.INITIAL_WRITE_FUTURE);
        this.mockSession.setReturnValue((Object)writeRequest.getFuture());
        this.session.removeAttribute(StreamWriteFilter.WRITE_REQUEST_QUEUE);
        this.mockSession.setReturnValue(null);
        this.nextFilter.messageSent(this.session, stream);
        this.mockNextFilter.replay();
        this.mockSession.replay();
        filter.filterWrite(this.nextFilter, this.session, writeRequest);
        filter.messageSent(this.nextFilter, this.session, chunk1);
        filter.messageSent(this.nextFilter, this.session, chunk2);
        filter.messageSent(this.nextFilter, this.session, chunk3);
        this.mockNextFilter.verify();
        this.mockSession.verify();
        StreamWriteFilterTest.assertTrue((boolean)writeRequest.getFuture().isWritten());
    }

    public void testWriteWhileWriteInProgress() throws Exception {
        StreamWriteFilter filter = new StreamWriteFilter();
        LinkedList queue = new LinkedList();
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[5]);
        this.mockSession.reset();
        this.session.getAttribute(StreamWriteFilter.CURRENT_STREAM);
        this.mockSession.setReturnValue((Object)stream);
        this.session.getAttribute(StreamWriteFilter.WRITE_REQUEST_QUEUE);
        this.mockSession.setReturnValue(queue);
        this.mockNextFilter.replay();
        this.mockSession.replay();
        IoFilter.WriteRequest wr = new IoFilter.WriteRequest(new Object(), new DummyWriteFuture());
        filter.filterWrite(this.nextFilter, this.session, wr);
        StreamWriteFilterTest.assertEquals((int)1, (int)queue.size());
        StreamWriteFilterTest.assertSame((Object)wr, queue.poll());
        this.mockNextFilter.verify();
        this.mockSession.verify();
    }

    public void testWritesWriteRequestQueueWhenFinished() throws Exception {
        StreamWriteFilter filter = new StreamWriteFilter();
        IoFilter.WriteRequest[] wrs = new IoFilter.WriteRequest[]{new IoFilter.WriteRequest(new Object(), new DummyWriteFuture()), new IoFilter.WriteRequest(new Object(), new DummyWriteFuture()), new IoFilter.WriteRequest(new Object(), new DummyWriteFuture())};
        LinkedList<IoFilter.WriteRequest> queue = new LinkedList<IoFilter.WriteRequest>();
        queue.add(wrs[0]);
        queue.add(wrs[1]);
        queue.add(wrs[2]);
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        this.mockSession.reset();
        this.session.getAttribute(StreamWriteFilter.CURRENT_STREAM);
        this.mockSession.setReturnValue((Object)stream);
        this.session.removeAttribute(StreamWriteFilter.CURRENT_STREAM);
        this.mockSession.setReturnValue((Object)stream);
        this.session.removeAttribute(StreamWriteFilter.INITIAL_WRITE_FUTURE);
        this.mockSession.setReturnValue((Object)new DefaultWriteFuture(this.session));
        this.session.removeAttribute(StreamWriteFilter.WRITE_REQUEST_QUEUE);
        this.mockSession.setReturnValue(queue);
        this.nextFilter.filterWrite(this.session, wrs[0]);
        this.session.getAttribute(StreamWriteFilter.CURRENT_STREAM);
        this.mockSession.setReturnValue(null);
        this.nextFilter.filterWrite(this.session, wrs[1]);
        this.session.getAttribute(StreamWriteFilter.CURRENT_STREAM);
        this.mockSession.setReturnValue(null);
        this.nextFilter.filterWrite(this.session, wrs[2]);
        this.session.getAttribute(StreamWriteFilter.CURRENT_STREAM);
        this.mockSession.setReturnValue(null);
        this.nextFilter.messageSent(this.session, stream);
        this.mockNextFilter.replay();
        this.mockSession.replay();
        filter.messageSent(this.nextFilter, this.session, new Object());
        StreamWriteFilterTest.assertEquals((int)0, (int)queue.size());
        this.mockNextFilter.verify();
        this.mockSession.verify();
    }

    public void testSetWriteBufferSize() throws Exception {
        StreamWriteFilter filter = new StreamWriteFilter();
        try {
            filter.setWriteBufferSize(0);
            StreamWriteFilterTest.fail((String)"0 writeBuferSize specified. IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            filter.setWriteBufferSize(-100);
            StreamWriteFilterTest.fail((String)"Negative writeBuferSize specified. IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        filter.setWriteBufferSize(1);
        StreamWriteFilterTest.assertEquals((int)1, (int)filter.getWriteBufferSize());
        filter.setWriteBufferSize(1024);
        StreamWriteFilterTest.assertEquals((int)1024, (int)filter.getWriteBufferSize());
    }

    public void testWriteUsingSocketTransport() throws Exception {
        SocketAcceptor acceptor = new SocketAcceptor();
        ((SocketAcceptorConfig)acceptor.getDefaultConfig()).setReuseAddress(true);
        InetSocketAddress address = new InetSocketAddress("localhost", AvailablePortFinder.getNextAvailable());
        SocketConnector connector = new SocketConnector();
        FixedRandomInputStream stream = new FixedRandomInputStream(0x400000L);
        SenderHandler sender = new SenderHandler(stream);
        ReceiverHandler receiver = new ReceiverHandler(stream.size);
        acceptor.bind(address, sender);
        connector.connect(address, receiver);
        sender.latch.await();
        receiver.latch.await();
        acceptor.unbind(address);
        StreamWriteFilterTest.assertEquals((long)stream.bytesRead, (long)receiver.bytesRead);
        StreamWriteFilterTest.assertEquals((long)stream.size, (long)receiver.bytesRead);
        byte[] expectedMd5 = stream.digest.digest();
        byte[] actualMd5 = receiver.digest.digest();
        StreamWriteFilterTest.assertEquals((int)expectedMd5.length, (int)actualMd5.length);
        int i = 0;
        while (i < expectedMd5.length) {
            StreamWriteFilterTest.assertEquals((byte)expectedMd5[i], (byte)actualMd5[i]);
            ++i;
        }
    }

    private static class DummyWriteFuture
    implements WriteFuture {
        private boolean written;

        private DummyWriteFuture() {
        }

        public boolean isWritten() {
            return this.written;
        }

        public void setWritten(boolean written) {
            this.written = written;
        }

        public IoSession getSession() {
            return null;
        }

        public Object getLock() {
            return this;
        }

        public void join() {
        }

        public boolean join(long timeoutInMillis) {
            return true;
        }

        public boolean isReady() {
            return true;
        }

        public void addListener(IoFutureListener listener) {
        }

        public void removeListener(IoFutureListener listener) {
        }
    }

    private static class FixedRandomInputStream
    extends InputStream {
        long size;
        long bytesRead = 0L;
        Random random = new Random();
        MessageDigest digest;

        FixedRandomInputStream(long size) throws Exception {
            this.size = size;
            this.digest = MessageDigest.getInstance("MD5");
        }

        public int read() throws IOException {
            if (this.isAllWritten()) {
                return -1;
            }
            ++this.bytesRead;
            byte b = (byte)this.random.nextInt(255);
            this.digest.update(b);
            return b;
        }

        public long getBytesRead() {
            return this.bytesRead;
        }

        public long getSize() {
            return this.size;
        }

        public boolean isAllWritten() {
            return this.bytesRead >= this.size;
        }
    }

    private static class ReceiverHandler
    extends IoHandlerAdapter {
        final CountDownLatch latch = new CountDownLatch(1);
        long bytesRead = 0L;
        long size = 0L;
        MessageDigest digest;

        ReceiverHandler(long size) throws Exception {
            this.size = size;
            this.digest = MessageDigest.getInstance("MD5");
        }

        public void sessionCreated(IoSession session) throws Exception {
            super.sessionCreated(session);
            session.setIdleTime(IdleStatus.READER_IDLE, 5);
        }

        public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
            session.close();
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            this.latch.countDown();
        }

        public void sessionClosed(IoSession session) throws Exception {
            this.latch.countDown();
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            ByteBuffer buf = (ByteBuffer)message;
            while (buf.hasRemaining()) {
                this.digest.update(buf.get());
                ++this.bytesRead;
            }
            if (this.bytesRead >= this.size) {
                session.close();
            }
        }
    }

    private static class SenderHandler
    extends IoHandlerAdapter {
        final CountDownLatch latch = new CountDownLatch(1);
        InputStream inputStream;
        StreamWriteFilter streamWriteFilter = new StreamWriteFilter();

        SenderHandler(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public void sessionCreated(IoSession session) throws Exception {
            super.sessionCreated(session);
            session.getFilterChain().addLast("codec", this.streamWriteFilter);
        }

        public void sessionOpened(IoSession session) throws Exception {
            session.write(this.inputStream);
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            this.latch.countDown();
        }

        public void sessionClosed(IoSession session) throws Exception {
            this.latch.countDown();
        }

        public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
            this.latch.countDown();
        }

        public void messageSent(IoSession session, Object message) throws Exception {
            if (message == this.inputStream) {
                this.latch.countDown();
            }
        }
    }

    public static class WriteRequestMatcher
    extends AbstractMatcher {
        protected boolean argumentMatches(Object expected, Object actual) {
            if (expected instanceof IoFilter.WriteRequest && actual instanceof IoFilter.WriteRequest) {
                IoFilter.WriteRequest w1 = (IoFilter.WriteRequest)expected;
                IoFilter.WriteRequest w2 = (IoFilter.WriteRequest)actual;
                return w1.getMessage().equals(w2.getMessage()) && w1.getFuture().isWritten() == w2.getFuture().isWritten();
            }
            return super.argumentMatches(expected, actual);
        }
    }
}

