/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoAcceptorConfig;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.util.IdentityHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IoServiceListenerSupport {
    private final List<IoServiceListener> listeners = new CopyOnWriteArrayList<IoServiceListener>();
    private final Set<SocketAddress> managedServiceAddresses = new CopyOnWriteArraySet<SocketAddress>();
    private final ConcurrentMap<SocketAddress, Set<IoSession>> managedSessions = new ConcurrentHashMap<SocketAddress, Set<IoSession>>();

    public void add(IoServiceListener listener) {
        this.listeners.add(listener);
    }

    public void remove(IoServiceListener listener) {
        this.listeners.remove(listener);
    }

    public Set<SocketAddress> getManagedServiceAddresses() {
        return Collections.unmodifiableSet(this.managedServiceAddresses);
    }

    public boolean isManaged(SocketAddress serviceAddress) {
        return this.managedServiceAddresses.contains(serviceAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IoSession> getManagedSessions(SocketAddress serviceAddress) {
        Set sessions = (Set)this.managedSessions.get(serviceAddress);
        if (sessions == null) {
            return Collections.emptySet();
        }
        Set set = sessions;
        synchronized (set) {
            return new IdentityHashSet<IoSession>(sessions);
        }
    }

    public void fireServiceActivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        if (!this.managedServiceAddresses.add(serviceAddress)) {
            return;
        }
        for (IoServiceListener listener : this.listeners) {
            try {
                listener.serviceActivated(service, serviceAddress, handler, config);
            }
            catch (Throwable e) {
                ExceptionMonitor.getInstance().exceptionCaught(e);
            }
        }
    }

    public synchronized void fireServiceDeactivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        if (!this.managedServiceAddresses.remove(serviceAddress)) {
            return;
        }
        try {
            for (IoServiceListener listener : this.listeners) {
                try {
                    listener.serviceDeactivated(service, serviceAddress, handler, config);
                }
                catch (Throwable e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        finally {
            this.disconnectSessions(serviceAddress, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionCreated(IoSession session) {
        boolean firstSession;
        SocketAddress serviceAddress = session.getServiceAddress();
        IdentityHashSet s = new IdentityHashSet();
        ConcurrentMap<SocketAddress, Set<IoSession>> concurrentMap = this.managedSessions;
        synchronized (concurrentMap) {
            Set<IoSession> sessions = this.managedSessions.putIfAbsent(serviceAddress, Collections.synchronizedSet(s));
            if (sessions == null) {
                sessions = s;
                firstSession = true;
            } else {
                firstSession = false;
            }
            if (!sessions.add(session)) {
                return;
            }
        }
        if (session.getService() instanceof IoConnector && firstSession) {
            this.fireServiceActivated(session.getService(), session.getServiceAddress(), session.getHandler(), session.getServiceConfig());
        }
        session.getFilterChain().fireSessionCreated(session);
        session.getFilterChain().fireSessionOpened(session);
        for (IoServiceListener listener : this.listeners) {
            try {
                listener.sessionCreated(session);
            }
            catch (Throwable e) {
                ExceptionMonitor.getInstance().exceptionCaught(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionDestroyed(IoSession session) {
        SocketAddress serviceAddress = session.getServiceAddress();
        boolean lastSession = false;
        ConcurrentMap<SocketAddress, Set<IoSession>> concurrentMap = this.managedSessions;
        synchronized (concurrentMap) {
            Set sessions = (Set)this.managedSessions.get(serviceAddress);
            if (sessions == null) {
                return;
            }
            sessions.remove(session);
            if (sessions.isEmpty()) {
                lastSession = this.managedSessions.remove(serviceAddress, sessions);
            }
        }
        session.getFilterChain().fireSessionClosed(session);
        try {
            for (IoServiceListener listener : this.listeners) {
                try {
                    listener.sessionDestroyed(session);
                }
                catch (Throwable e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        finally {
            if (session.getService() instanceof IoConnector && lastSession) {
                this.fireServiceDeactivated(session.getService(), session.getServiceAddress(), session.getHandler(), session.getServiceConfig());
            }
        }
    }

    private void disconnectSessions(SocketAddress serviceAddress, IoServiceConfig config) {
        if (!(config instanceof IoAcceptorConfig)) {
            return;
        }
        if (!((IoAcceptorConfig)config).isDisconnectOnUnbind()) {
            return;
        }
        Set<IoSession> sessions = this.getManagedSessions(serviceAddress);
        if (sessions.isEmpty()) {
            return;
        }
        final CountDownLatch latch = new CountDownLatch(sessions.size());
        for (IoSession session : sessions) {
            session.close().addListener(new IoFutureListener(){

                public void operationComplete(IoFuture future) {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeIOException(e);
        }
    }
}

