/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;

public class DefaultIoFilterChainBuilderTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(DefaultIoFilterChainBuilderTest.class);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testAdd() throws Exception {
        DefaultIoFilterChainBuilder builder = new DefaultIoFilterChainBuilder();
        builder.addFirst("A", new IoFilterAdapter());
        builder.addLast("B", new IoFilterAdapter());
        builder.addFirst("C", new IoFilterAdapter());
        builder.addLast("D", new IoFilterAdapter());
        builder.addBefore("B", "E", new IoFilterAdapter());
        builder.addBefore("C", "F", new IoFilterAdapter());
        builder.addAfter("B", "G", new IoFilterAdapter());
        builder.addAfter("D", "H", new IoFilterAdapter());
        String actual = "";
        for (IoFilterChain.Entry e : builder.getAll()) {
            actual = String.valueOf(actual) + e.getName();
        }
        Assert.assertEquals((String)"FCAEBGDH", (String)actual);
    }

    public void testGet() throws Exception {
        DefaultIoFilterChainBuilder builder = new DefaultIoFilterChainBuilder();
        IoFilterAdapter filterA = new IoFilterAdapter();
        IoFilterAdapter filterB = new IoFilterAdapter();
        IoFilterAdapter filterC = new IoFilterAdapter();
        IoFilterAdapter filterD = new IoFilterAdapter();
        builder.addFirst("A", filterA);
        builder.addLast("B", filterB);
        builder.addBefore("B", "C", filterC);
        builder.addAfter("A", "D", filterD);
        Assert.assertSame((Object)filterA, (Object)builder.get("A"));
        Assert.assertSame((Object)filterB, (Object)builder.get("B"));
        Assert.assertSame((Object)filterC, (Object)builder.get("C"));
        Assert.assertSame((Object)filterD, (Object)builder.get("D"));
    }

    public void testRemove() throws Exception {
        DefaultIoFilterChainBuilder builder = new DefaultIoFilterChainBuilder();
        builder.addLast("A", new IoFilterAdapter());
        builder.addLast("B", new IoFilterAdapter());
        builder.addLast("C", new IoFilterAdapter());
        builder.addLast("D", new IoFilterAdapter());
        builder.addLast("E", new IoFilterAdapter());
        builder.remove("A");
        builder.remove("E");
        builder.remove("C");
        builder.remove("B");
        builder.remove("D");
        Assert.assertEquals((int)0, (int)builder.getAll().size());
    }

    public void testClear() throws Exception {
        DefaultIoFilterChainBuilder builder = new DefaultIoFilterChainBuilder();
        builder.addLast("A", new IoFilterAdapter());
        builder.addLast("B", new IoFilterAdapter());
        builder.addLast("C", new IoFilterAdapter());
        builder.addLast("D", new IoFilterAdapter());
        builder.addLast("E", new IoFilterAdapter());
        builder.clear();
        Assert.assertEquals((int)0, (int)builder.getAll().size());
    }

    public void testToString() {
        DefaultIoFilterChainBuilder builder = new DefaultIoFilterChainBuilder();
        Assert.assertEquals((String)"{ empty }", (String)builder.toString());
        builder.addLast("A", new IoFilterAdapter(){

            public String toString() {
                return "B";
            }
        });
        Assert.assertEquals((String)"{ (A:B) }", (String)builder.toString());
        builder.addLast("C", new IoFilterAdapter(){

            public String toString() {
                return "D";
            }
        });
        Assert.assertEquals((String)"{ (A:B), (C:D) }", (String)builder.toString());
    }
}

