/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.PooledByteBufferAllocator;

public class ByteBufferTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(ByteBufferTest.class);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testAllocate() throws Exception {
        int i = 10;
        while (i < 0x200000) {
            ByteBuffer buf = ByteBuffer.allocate(i);
            Assert.assertEquals((int)0, (int)buf.position());
            Assert.assertEquals((int)buf.capacity(), (int)buf.remaining());
            Assert.assertTrue((buf.capacity() >= i ? 1 : 0) != 0);
            Assert.assertTrue((buf.capacity() < i * 2 ? 1 : 0) != 0);
            i = i * 11 / 10;
        }
    }

    public void testRelease() throws Exception {
        int i = 10;
        while (i < 0x200000) {
            ByteBuffer buf = ByteBuffer.allocate(i);
            Assert.assertEquals((int)0, (int)buf.position());
            Assert.assertEquals((int)buf.capacity(), (int)buf.remaining());
            Assert.assertTrue((buf.capacity() >= i ? 1 : 0) != 0);
            Assert.assertTrue((buf.capacity() < i * 2 ? 1 : 0) != 0);
            buf.release();
            i = i * 11 / 10;
        }
    }

    public void testLeakageDetection() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(1024);
        buf.release();
        try {
            buf.release();
            Assert.fail((String)"Releasing a buffer twice should fail.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testAcquireRelease() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(1024);
        buf.acquire();
        buf.release();
        buf.acquire();
        buf.acquire();
        buf.release();
        buf.release();
        buf.release();
        try {
            buf.release();
            Assert.fail((String)"Releasing a buffer twice should fail.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testAutoExpand() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(1);
        buf.put((byte)0);
        try {
            buf.put((byte)0);
            Assert.fail();
        }
        catch (BufferOverflowException bufferOverflowException) {
            // empty catch block
        }
        buf.setAutoExpand(true);
        buf.put((byte)0);
        Assert.assertEquals((int)2, (int)buf.position());
        Assert.assertEquals((int)2, (int)buf.limit());
        Assert.assertEquals((int)2, (int)buf.capacity());
        buf.setAutoExpand(false);
        try {
            buf.put(3, (byte)0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        buf.setAutoExpand(true);
        buf.put(3, (byte)0);
        Assert.assertEquals((int)2, (int)buf.position());
        Assert.assertEquals((int)4, (int)buf.limit());
        Assert.assertEquals((int)4, (int)buf.capacity());
    }

    public void testAutoExpandMark() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(4).setAutoExpand(true);
        buf.put((byte)0);
        buf.put((byte)0);
        buf.put((byte)0);
        buf.mark();
        buf.put((byte)0);
        buf.put((byte)0);
        Assert.assertEquals((int)5, (int)buf.position());
        buf.reset();
        Assert.assertEquals((int)3, (int)buf.position());
    }

    public void testPooledProperty() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(16);
        java.nio.ByteBuffer nioBuf = buf.buf();
        buf.release();
        buf = ByteBuffer.allocate(16);
        Assert.assertSame((Object)nioBuf, (Object)buf.buf());
        buf.setPooled(false);
        buf.release();
        Assert.assertNotSame((Object)nioBuf, (Object)ByteBuffer.allocate(16).buf());
    }

    public void testGetString() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(16);
        Charset charset = Charset.forName("UTF-8");
        buf.clear();
        buf.putString("hello", charset.newEncoder());
        buf.put((byte)0);
        buf.flip();
        Assert.assertEquals((String)"hello", (String)buf.getString(charset.newDecoder()));
        buf.clear();
        buf.putString("hello", charset.newEncoder());
        buf.flip();
        Assert.assertEquals((String)"hello", (String)buf.getString(charset.newDecoder()));
        CharsetDecoder decoder = Charset.forName("ISO-8859-1").newDecoder();
        buf.clear();
        buf.put((byte)65);
        buf.put((byte)66);
        buf.put((byte)67);
        buf.put((byte)0);
        buf.position(0);
        Assert.assertEquals((String)"ABC", (String)buf.getString(decoder));
        Assert.assertEquals((int)4, (int)buf.position());
        buf.position(0);
        buf.limit(1);
        Assert.assertEquals((String)"A", (String)buf.getString(decoder));
        Assert.assertEquals((int)1, (int)buf.position());
        buf.clear();
        Assert.assertEquals((String)"ABC", (String)buf.getString(10, decoder));
        Assert.assertEquals((int)10, (int)buf.position());
        buf.clear();
        Assert.assertEquals((String)"A", (String)buf.getString(1, decoder));
        Assert.assertEquals((int)1, (int)buf.position());
        buf.clear();
        buf.put((byte)65);
        buf.put((byte)66);
        buf.put((byte)0);
        buf.put((byte)67);
        buf.position(0);
        Assert.assertEquals((String)"AB", (String)buf.getString(4, decoder));
        Assert.assertEquals((int)4, (int)buf.position());
        buf.clear();
        buf.fillAndReset(buf.limit());
        decoder = Charset.forName("UTF-16").newDecoder();
        buf.put((byte)0);
        buf.put((byte)65);
        buf.put((byte)0);
        buf.put((byte)66);
        buf.put((byte)0);
        buf.put((byte)67);
        buf.put((byte)0);
        buf.put((byte)0);
        buf.position(0);
        Assert.assertEquals((String)"ABC", (String)buf.getString(decoder));
        Assert.assertEquals((int)8, (int)buf.position());
        buf.position(0);
        buf.limit(2);
        Assert.assertEquals((String)"A", (String)buf.getString(decoder));
        Assert.assertEquals((int)2, (int)buf.position());
        buf.position(0);
        buf.limit(3);
        Assert.assertEquals((String)"A", (String)buf.getString(decoder));
        Assert.assertEquals((int)2, (int)buf.position());
        buf.clear();
        Assert.assertEquals((String)"ABC", (String)buf.getString(10, decoder));
        Assert.assertEquals((int)10, (int)buf.position());
        buf.clear();
        Assert.assertEquals((String)"A", (String)buf.getString(2, decoder));
        Assert.assertEquals((int)2, (int)buf.position());
        buf.clear();
        try {
            buf.getString(1, decoder);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        buf.clear();
        buf.limit(0);
        Assert.assertEquals((String)"", (String)buf.getString(decoder));
        Assert.assertEquals((String)"", (String)buf.getString(2, decoder));
        buf.clear();
        buf.putInt(0);
        buf.clear();
        buf.limit(4);
        Assert.assertEquals((String)"", (String)buf.getString(decoder));
        Assert.assertEquals((int)2, (int)buf.position());
        Assert.assertEquals((int)4, (int)buf.limit());
        buf.position(0);
        Assert.assertEquals((String)"", (String)buf.getString(2, decoder));
        Assert.assertEquals((int)2, (int)buf.position());
        Assert.assertEquals((int)4, (int)buf.limit());
    }

    public void testGetStringWithFailure() throws Exception {
        String test = "\u30b3\u30e1\u30f3\u30c8\u7de8\u96c6";
        ByteBuffer buffer = ByteBuffer.wrap(test.getBytes("Shift_JIS"));
        int oldLimit = buffer.limit();
        int oldPos = buffer.position();
        try {
            buffer.getString(3, Charset.forName("ASCII").newDecoder());
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((int)oldLimit, (int)buffer.limit());
            Assert.assertEquals((int)oldPos, (int)buffer.position());
        }
        try {
            buffer.getString(Charset.forName("ASCII").newDecoder());
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((int)oldLimit, (int)buffer.limit());
            Assert.assertEquals((int)oldPos, (int)buffer.position());
        }
    }

    public void testPutString() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(16);
        CharsetEncoder encoder = Charset.forName("ISO-8859-1").newEncoder();
        buf.putString("ABC", encoder);
        Assert.assertEquals((int)3, (int)buf.position());
        buf.clear();
        Assert.assertEquals((int)65, (int)buf.get(0));
        Assert.assertEquals((int)66, (int)buf.get(1));
        Assert.assertEquals((int)67, (int)buf.get(2));
        buf.putString("D", 5, encoder);
        Assert.assertEquals((int)5, (int)buf.position());
        buf.clear();
        Assert.assertEquals((int)68, (int)buf.get(0));
        Assert.assertEquals((int)0, (int)buf.get(1));
        buf.putString("EFG", 2, encoder);
        Assert.assertEquals((int)2, (int)buf.position());
        buf.clear();
        Assert.assertEquals((int)69, (int)buf.get(0));
        Assert.assertEquals((int)70, (int)buf.get(1));
        Assert.assertEquals((int)67, (int)buf.get(2));
        encoder = Charset.forName("UTF-16BE").newEncoder();
        buf.clear();
        buf.putString("ABC", encoder);
        Assert.assertEquals((int)6, (int)buf.position());
        buf.clear();
        Assert.assertEquals((int)0, (int)buf.get(0));
        Assert.assertEquals((int)65, (int)buf.get(1));
        Assert.assertEquals((int)0, (int)buf.get(2));
        Assert.assertEquals((int)66, (int)buf.get(3));
        Assert.assertEquals((int)0, (int)buf.get(4));
        Assert.assertEquals((int)67, (int)buf.get(5));
        buf.putString("D", 10, encoder);
        Assert.assertEquals((int)10, (int)buf.position());
        buf.clear();
        Assert.assertEquals((int)0, (int)buf.get(0));
        Assert.assertEquals((int)68, (int)buf.get(1));
        Assert.assertEquals((int)0, (int)buf.get(2));
        Assert.assertEquals((int)0, (int)buf.get(3));
        buf.putString("EFG", 4, encoder);
        Assert.assertEquals((int)4, (int)buf.position());
        buf.clear();
        Assert.assertEquals((int)0, (int)buf.get(0));
        Assert.assertEquals((int)69, (int)buf.get(1));
        Assert.assertEquals((int)0, (int)buf.get(2));
        Assert.assertEquals((int)70, (int)buf.get(3));
        Assert.assertEquals((int)0, (int)buf.get(4));
        Assert.assertEquals((int)67, (int)buf.get(5));
        buf.putString("", encoder);
        Assert.assertEquals((int)0, (int)buf.position());
        buf.putString("", 4, encoder);
        Assert.assertEquals((int)4, (int)buf.position());
        Assert.assertEquals((int)0, (int)buf.get(0));
        Assert.assertEquals((int)0, (int)buf.get(1));
    }

    public void testGetPrefixedString() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(16);
        CharsetEncoder encoder = Charset.forName("ISO-8859-1").newEncoder();
        CharsetDecoder decoder = Charset.forName("ISO-8859-1").newDecoder();
        buf.putShort((short)3);
        buf.putString("ABCD", encoder);
        buf.clear();
        Assert.assertEquals((String)"ABC", (String)buf.getPrefixedString(decoder));
    }

    public void testPutPrefixedString() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.fillAndReset(buf.remaining());
        CharsetEncoder encoder = Charset.forName("ISO-8859-1").newEncoder();
        buf.putPrefixedString("ABC", encoder);
        Assert.assertEquals((int)5, (int)buf.position());
        Assert.assertEquals((int)0, (int)buf.get(0));
        Assert.assertEquals((int)3, (int)buf.get(1));
        Assert.assertEquals((int)65, (int)buf.get(2));
        Assert.assertEquals((int)66, (int)buf.get(3));
        Assert.assertEquals((int)67, (int)buf.get(4));
        buf.clear();
        try {
            buf.putPrefixedString("123456789012345", encoder);
            Assert.fail();
        }
        catch (BufferOverflowException bufferOverflowException) {
            // empty catch block
        }
        buf.clear();
        buf.setAutoExpand(true);
        buf.putPrefixedString("123456789012345", encoder);
        Assert.assertEquals((int)17, (int)buf.position());
        Assert.assertEquals((int)0, (int)buf.get(0));
        Assert.assertEquals((int)15, (int)buf.get(1));
        Assert.assertEquals((int)49, (int)buf.get(2));
        Assert.assertEquals((int)50, (int)buf.get(3));
        Assert.assertEquals((int)51, (int)buf.get(4));
        Assert.assertEquals((int)52, (int)buf.get(5));
        Assert.assertEquals((int)53, (int)buf.get(6));
        Assert.assertEquals((int)54, (int)buf.get(7));
        Assert.assertEquals((int)55, (int)buf.get(8));
        Assert.assertEquals((int)56, (int)buf.get(9));
        Assert.assertEquals((int)57, (int)buf.get(10));
        Assert.assertEquals((int)48, (int)buf.get(11));
        Assert.assertEquals((int)49, (int)buf.get(12));
        Assert.assertEquals((int)50, (int)buf.get(13));
        Assert.assertEquals((int)51, (int)buf.get(14));
        Assert.assertEquals((int)52, (int)buf.get(15));
        Assert.assertEquals((int)53, (int)buf.get(16));
    }

    public void testPutPrefixedStringWithPrefixLength() throws Exception {
        CharsetEncoder encoder = Charset.forName("ISO-8859-1").newEncoder();
        ByteBuffer buf = ByteBuffer.allocate(16).sweep().setAutoExpand(true);
        buf.putPrefixedString("A", 1, encoder);
        Assert.assertEquals((int)2, (int)buf.position());
        Assert.assertEquals((int)1, (int)buf.get(0));
        Assert.assertEquals((int)65, (int)buf.get(1));
        buf.sweep();
        buf.putPrefixedString("A", 2, encoder);
        Assert.assertEquals((int)3, (int)buf.position());
        Assert.assertEquals((int)0, (int)buf.get(0));
        Assert.assertEquals((int)1, (int)buf.get(1));
        Assert.assertEquals((int)65, (int)buf.get(2));
        buf.sweep();
        buf.putPrefixedString("A", 4, encoder);
        Assert.assertEquals((int)5, (int)buf.position());
        Assert.assertEquals((int)0, (int)buf.get(0));
        Assert.assertEquals((int)0, (int)buf.get(1));
        Assert.assertEquals((int)0, (int)buf.get(2));
        Assert.assertEquals((int)1, (int)buf.get(3));
        Assert.assertEquals((int)65, (int)buf.get(4));
    }

    public void testPutPrefixedStringWithPadding() throws Exception {
        CharsetEncoder encoder = Charset.forName("ISO-8859-1").newEncoder();
        ByteBuffer buf = ByteBuffer.allocate(16).sweep().setAutoExpand(true);
        buf.putPrefixedString("A", 1, 2, (byte)32, encoder);
        Assert.assertEquals((int)3, (int)buf.position());
        Assert.assertEquals((int)2, (int)buf.get(0));
        Assert.assertEquals((int)65, (int)buf.get(1));
        Assert.assertEquals((int)32, (int)buf.get(2));
        buf.sweep();
        buf.putPrefixedString("A", 1, 4, (byte)32, encoder);
        Assert.assertEquals((int)5, (int)buf.position());
        Assert.assertEquals((int)4, (int)buf.get(0));
        Assert.assertEquals((int)65, (int)buf.get(1));
        Assert.assertEquals((int)32, (int)buf.get(2));
        Assert.assertEquals((int)32, (int)buf.get(3));
        Assert.assertEquals((int)32, (int)buf.get(4));
    }

    public void testWideUtf8Characters() throws Exception {
        Runnable r = new Runnable(){

            public void run() {
                ByteBuffer buffer = ByteBuffer.allocate(1);
                buffer.setAutoExpand(true);
                Charset charset = Charset.forName("UTF-8");
                CharsetEncoder encoder = charset.newEncoder();
                int i = 0;
                while (i < 5) {
                    try {
                        buffer.putString("\u89d2", encoder);
                    }
                    catch (CharacterCodingException e) {
                        ByteBufferTest.fail((String)e.getMessage());
                    }
                    ++i;
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
        int i = 0;
        while (i < 50) {
            Thread.sleep(100L);
            if (!t.isAlive()) break;
            ++i;
        }
        if (t.isAlive()) {
            t.interrupt();
            ByteBufferTest.fail((String)"Went into endless loop trying to encode character");
        }
    }

    public void testObjectSerialization() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.setAutoExpand(true);
        ArrayList<Serializable> o = new ArrayList<Serializable>();
        o.add(new Date());
        o.add(Long.TYPE);
        buf.putObject(o);
        buf.clear();
        Object o2 = buf.getObject();
        Assert.assertEquals(o, (Object)o2);
        Assert.assertNotSame(o, (Object)o2);
    }

    public void testSweepWithZeros() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(-559038737);
        buf.clear();
        Assert.assertEquals((int)-559038737, (int)buf.getInt());
        Assert.assertEquals((int)4, (int)buf.position());
        Assert.assertEquals((int)4, (int)buf.limit());
        buf.sweep();
        Assert.assertEquals((int)0, (int)buf.position());
        Assert.assertEquals((int)4, (int)buf.limit());
        Assert.assertEquals((int)0, (int)buf.getInt());
    }

    public void testSweepNonZeros() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(-559038737);
        buf.clear();
        Assert.assertEquals((int)-559038737, (int)buf.getInt());
        Assert.assertEquals((int)4, (int)buf.position());
        Assert.assertEquals((int)4, (int)buf.limit());
        buf.sweep((byte)69);
        Assert.assertEquals((int)0, (int)buf.position());
        Assert.assertEquals((int)4, (int)buf.limit());
        Assert.assertEquals((int)0x45454545, (int)buf.getInt());
    }

    public void testWrapNioBuffer() throws Exception {
        java.nio.ByteBuffer nioBuf = java.nio.ByteBuffer.allocate(10);
        nioBuf.position(3);
        nioBuf.limit(7);
        ByteBuffer buf = ByteBuffer.wrap(nioBuf);
        Assert.assertEquals((int)3, (int)buf.position());
        Assert.assertEquals((int)7, (int)buf.limit());
        Assert.assertEquals((int)10, (int)buf.capacity());
    }

    public void testWrapSubArray() throws Exception {
        byte[] array = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        ByteBuffer buf = ByteBuffer.wrap(array, 3, 4);
        Assert.assertEquals((int)3, (int)buf.position());
        Assert.assertEquals((int)7, (int)buf.limit());
        Assert.assertEquals((int)10, (int)buf.capacity());
        buf.clear();
        Assert.assertEquals((int)0, (int)buf.position());
        Assert.assertEquals((int)10, (int)buf.limit());
        Assert.assertEquals((int)10, (int)buf.capacity());
    }

    public void testPoolExpiration() throws Exception {
        PooledByteBufferAllocator allocator = (PooledByteBufferAllocator)ByteBuffer.getAllocator();
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.release();
        allocator.setTimeout(1);
        Thread.sleep(2000L);
        Assert.assertNotSame((Object)buf, (Object)ByteBuffer.allocate(16));
        allocator.setTimeout(10);
        buf = ByteBuffer.allocate(16);
        buf.release();
        Thread.sleep(2000L);
        Assert.assertSame((Object)buf.buf(), (Object)ByteBuffer.allocate(16).buf());
        allocator.setTimeout(60);
    }

    public void testAllocatorDisposal() throws Exception {
        PooledByteBufferAllocator allocator = (PooledByteBufferAllocator)ByteBuffer.getAllocator();
        try {
            allocator.dispose();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ByteBuffer.setAllocator(new PooledByteBufferAllocator());
        allocator.dispose();
        try {
            allocator.allocate(16, true);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testDuplicate() throws Exception {
        ByteBuffer original = ByteBuffer.allocate(16).sweep();
        java.nio.ByteBuffer nioBuf = original.buf();
        original.position(4);
        original.limit(10);
        ByteBuffer duplicate = original.duplicate();
        original.put(4, (byte)127);
        Assert.assertEquals((int)4, (int)duplicate.position());
        Assert.assertEquals((int)10, (int)duplicate.limit());
        Assert.assertEquals((int)16, (int)duplicate.capacity());
        Assert.assertNotSame((Object)original.buf(), (Object)duplicate.buf());
        Assert.assertEquals((int)127, (int)duplicate.get(4));
        original.release();
        duplicate.release();
        original = ByteBuffer.allocate(16);
        Assert.assertSame((Object)nioBuf, (Object)original.buf());
        original.release();
        original = ByteBuffer.allocate(16);
        duplicate = original.duplicate();
        duplicate.release();
        original.release();
        original = ByteBuffer.allocate(16);
        Assert.assertSame((Object)nioBuf, (Object)original.buf());
        original.release();
        original = ByteBuffer.allocate(16);
        duplicate = original.duplicate();
        ByteBuffer anotherDuplicate = duplicate.duplicate();
        anotherDuplicate.release();
        original.release();
        duplicate.release();
        try {
            duplicate.release();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            anotherDuplicate.release();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        original = ByteBuffer.allocate(16);
        Assert.assertSame((Object)nioBuf, (Object)original.buf());
        original.release();
        try {
            original = ByteBuffer.allocate(16);
            duplicate = original.duplicate();
            duplicate.setAutoExpand(true);
            duplicate.putString("A very very very very looooooong string", Charset.forName("ISO-8859-1").newEncoder());
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSlice() throws Exception {
        ByteBuffer original = ByteBuffer.allocate(16).sweep();
        original.position(4);
        original.limit(10);
        ByteBuffer slice = original.slice();
        original.put(4, (byte)127);
        Assert.assertEquals((int)0, (int)slice.position());
        Assert.assertEquals((int)6, (int)slice.limit());
        Assert.assertEquals((int)6, (int)slice.capacity());
        Assert.assertNotSame((Object)original.buf(), (Object)slice.buf());
        Assert.assertEquals((int)127, (int)slice.get(0));
        original.release();
        slice.release();
    }

    public void testReadOnlyBuffer() throws Exception {
        ByteBuffer original = ByteBuffer.allocate(16).sweep();
        original.position(4);
        original.limit(10);
        ByteBuffer duplicate = original.asReadOnlyBuffer();
        original.put(4, (byte)127);
        Assert.assertEquals((int)4, (int)duplicate.position());
        Assert.assertEquals((int)10, (int)duplicate.limit());
        Assert.assertEquals((int)16, (int)duplicate.capacity());
        Assert.assertNotSame((Object)original.buf(), (Object)duplicate.buf());
        Assert.assertEquals((int)127, (int)duplicate.get(4));
        original.release();
        duplicate.release();
        try {
            original = ByteBuffer.allocate(16);
            duplicate = original.asReadOnlyBuffer();
            duplicate.putString("A very very very very looooooong string", Charset.forName("ISO-8859-1").newEncoder());
            Assert.fail();
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            // empty catch block
        }
    }

    public void testGetUnsigned() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.put((byte)-92);
        buf.put((byte)-48);
        buf.put((byte)-77);
        buf.put((byte)-51);
        buf.flip();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.mark();
        Assert.assertEquals((int)164, (int)buf.getUnsigned());
        buf.reset();
        Assert.assertEquals((int)53412, (int)buf.getUnsignedShort());
        buf.reset();
        Assert.assertEquals((long)3451113636L, (long)buf.getUnsignedInt());
    }
}

