/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.validation;

import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.StateType;
import com.evelopers.unimod.core.stateworks.Transition;
import com.evelopers.unimod.validation.StructureListener;
import com.evelopers.unimod.validation.StructureVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class StructureValidator
extends StructureVisitor {
    private List strucutreListeners = new ArrayList();

    StructureValidator() {
    }

    public boolean addStrucutreListener(StructureListener listener) {
        return this.strucutreListeners.add(listener);
    }

    public boolean removeStrucutreListener(StructureListener listener) {
        return this.strucutreListeners.remove(listener);
    }

    public void validateStructure(StateMachine sm) {
        State state;
        this.attainableStates.clear();
        this.initialStateLess.clear();
        this.redundantInitStates.clear();
        this.notRootMachinesWithEventProviders.clear();
        this.attainableStates.clear();
        this.visit(sm.getTop());
        this.addAttainableSuperstates();
        Iterator<Object> i = sm.getAllStates().iterator();
        while (i.hasNext()) {
            state = (State)i.next();
            if (this.attainableStates.contains(state)) continue;
            this.fireUnattainableState(sm, state);
        }
        i = this.getNoInitState().iterator();
        while (i.hasNext()) {
            this.fireNoInitState(sm, (State)i.next());
        }
        i = this.redundantInitStates.keySet().iterator();
        while (i.hasNext()) {
            state = (State)i.next();
            int initStateNumber = (Integer)this.redundantInitStates.get(state);
            this.fireRedundantInitStates(sm, state, initStateNumber);
        }
        i = this.notRootMachinesWithEventProviders.iterator();
        while (i.hasNext()) {
            StateMachine s = (StateMachine)i.next();
            this.fireNotRootStateMacineHasEventProviders(s);
        }
        i = sm.getAllStates().iterator();
        while (i.hasNext()) {
            Transition transition;
            state = (State)i.next();
            if (StateType.INITIAL.equals(state.getType())) {
                Transition transition2;
                int numberOfTransitions = 0;
                Iterator j = state.getOutgoingTransitions().iterator();
                while (j.hasNext()) {
                    transition2 = (Transition)j.next();
                    ++numberOfTransitions;
                    if (!Guard.TRUE.equals(transition2.getGuard())) {
                        this.fireBadTransitionFromInitState(sm, transition2);
                    }
                    if (Event.NO_EVENT.equals(transition2.getEvent())) continue;
                    this.fireBadTransitionFromInitState(sm, transition2);
                }
                if (numberOfTransitions == 0) {
                    this.fireNoTransitionFromInitState(sm, state);
                } else if (numberOfTransitions > 1) {
                    this.fireRedundantTransitionsFromInitState(sm, state, numberOfTransitions);
                }
                j = state.getIncomingTransitions().iterator();
                while (j.hasNext()) {
                    transition2 = (Transition)j.next();
                    this.fireIncomingTransitionToInitState(sm, transition2);
                }
            } else {
                Iterator j = state.getOutgoingTransitions().iterator();
                while (j.hasNext()) {
                    transition = (Transition)j.next();
                    if (!Event.NO_EVENT.equals(transition.getEvent())) continue;
                    this.fireNoEventOnTransition(sm, transition);
                }
            }
            if (!StateType.FINAL.equals(state.getType())) continue;
            Iterator j = state.getOutgoingTransitions().iterator();
            while (j.hasNext()) {
                transition = (Transition)j.next();
                this.fireOutgoingTransitionFromFinalState(sm, transition);
            }
        }
    }

    private void addAttainableSuperstates() {
        HashSet<State> attainableSupertates = new HashSet<State>();
        Iterator i = this.attainableStates.iterator();
        while (i.hasNext()) {
            State state = (State)i.next();
            State cur = state.getSuperstate();
            while (cur != null) {
                attainableSupertates.add(cur);
                cur = cur.getSuperstate();
            }
        }
        this.attainableStates.addAll(attainableSupertates);
    }

    private void fireUnattainableState(StateMachine sm, State state) {
        Iterator i = this.strucutreListeners.iterator();
        while (i.hasNext()) {
            StructureListener structureListener = (StructureListener)i.next();
            structureListener.unattainableState(sm, state);
        }
    }

    private void fireNoInitState(StateMachine sm, State state) {
        Iterator i = this.strucutreListeners.iterator();
        while (i.hasNext()) {
            StructureListener structureListener = (StructureListener)i.next();
            structureListener.noInitState(sm, state);
        }
    }

    private void fireRedundantInitStates(StateMachine sm, State state, int initStateNumber) {
        Iterator i = this.strucutreListeners.iterator();
        while (i.hasNext()) {
            StructureListener structureListener = (StructureListener)i.next();
            structureListener.redundantInitStates(sm, state, initStateNumber);
        }
    }

    private void fireNotRootStateMacineHasEventProviders(StateMachine sm) {
        Iterator i = this.strucutreListeners.iterator();
        while (i.hasNext()) {
            StructureListener structureListener = (StructureListener)i.next();
            structureListener.notRootStateMachineHasEventProviders(sm);
        }
    }

    private void fireBadTransitionFromInitState(StateMachine sm, Transition transition) {
        Iterator i = this.strucutreListeners.iterator();
        while (i.hasNext()) {
            StructureListener structureListener = (StructureListener)i.next();
            structureListener.badTransitionFromInitState(sm, transition);
        }
    }

    private void fireNoTransitionFromInitState(StateMachine sm, State initState) {
        Iterator i = this.strucutreListeners.iterator();
        while (i.hasNext()) {
            StructureListener structureListener = (StructureListener)i.next();
            structureListener.noTransitionFromInitState(sm, initState);
        }
    }

    private void fireRedundantTransitionsFromInitState(StateMachine sm, State initState, int transitionsNumber) {
        Iterator i = this.strucutreListeners.iterator();
        while (i.hasNext()) {
            StructureListener structureListener = (StructureListener)i.next();
            structureListener.redundantTransitionsFromInitState(sm, initState, transitionsNumber);
        }
    }

    private void fireIncomingTransitionToInitState(StateMachine sm, Transition transition) {
        Iterator i = this.strucutreListeners.iterator();
        while (i.hasNext()) {
            StructureListener structureListener = (StructureListener)i.next();
            structureListener.incomingTransitionToInitState(sm, transition);
        }
    }

    private void fireOutgoingTransitionFromFinalState(StateMachine sm, Transition transition) {
        Iterator i = this.strucutreListeners.iterator();
        while (i.hasNext()) {
            StructureListener structureListener = (StructureListener)i.next();
            structureListener.outgoingTransitionFromFinalState(sm, transition);
        }
    }

    private void fireNoEventOnTransition(StateMachine sm, Transition transition) {
        Iterator i = this.strucutreListeners.iterator();
        while (i.hasNext()) {
            StructureListener structureListener = (StructureListener)i.next();
            structureListener.noEventOnTransition(sm, transition);
        }
    }
}

