/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.validation;

import com.evelopers.unimod.core.VisitorException;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.Transition;
import com.evelopers.unimod.validation.ConsistencyCheckVisitor;
import com.evelopers.unimod.validation.ConsistencyListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ConsistencyValidator
extends ConsistencyCheckVisitor {
    private List consistencyListeners = new ArrayList();

    ConsistencyValidator() {
    }

    public boolean addConsistencyListener(ConsistencyListener listener) {
        return this.consistencyListeners.add(listener);
    }

    public boolean removeConsistencyListener(ConsistencyListener listener) {
        return this.consistencyListeners.remove(listener);
    }

    public void validateConsistency(StateMachine sm) {
        if (sm.getTop() == null) {
            throw new IllegalArgumentException("State machine " + sm.getName() + " doesn't have top state");
        }
        this.setSm(sm);
        try {
            sm.getTop().accept(this);
        }
        catch (VisitorException e) {
            e.printStackTrace();
        }
    }

    public void validateConsistency(StateMachine sm, State state) {
        this.setSm(sm);
        try {
            this.checkState(state);
        }
        catch (VisitorException e) {
            e.printStackTrace();
        }
    }

    protected void fireInconsistentGuardSet(StateMachine sm, Transition t1, Transition t2, Guard guard) {
        Iterator i = this.consistencyListeners.iterator();
        while (i.hasNext()) {
            ConsistencyListener consistencyListener = (ConsistencyListener)i.next();
            consistencyListener.inconsistentGuardSet(sm, t1, t2, guard);
        }
    }

    protected void fireRedundantElseTransitions(StateMachine sm, State state, Event e, int elseTransitionsNumber) {
        Iterator i = this.consistencyListeners.iterator();
        while (i.hasNext()) {
            ConsistencyListener consistencyListener = (ConsistencyListener)i.next();
            consistencyListener.redundantElseTransitions(sm, state, e, elseTransitionsNumber);
        }
    }
}

