/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.validation;

import antlr.RecognitionException;
import antlr.collections.AST;
import com.evelopers.unimod.analysis.FormulaResolver;
import com.evelopers.unimod.core.ModelElement;
import com.evelopers.unimod.core.ModelVisitor;
import com.evelopers.unimod.core.VisitorException;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.Transition;
import com.evelopers.unimod.validation.StateTransitionsDecorator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

abstract class CompletenessCheckVisitor
implements ModelVisitor {
    private StateMachine sm;

    CompletenessCheckVisitor() {
    }

    public void setSm(StateMachine sm) {
        this.sm = sm;
    }

    public boolean visit(ModelElement e) throws VisitorException {
        if (e instanceof State) {
            State state = (State)e;
            if (!state.isComposite()) {
                this.checkState(state);
                return false;
            }
            return true;
        }
        throw new VisitorException(e + " is not a state!");
    }

    protected void checkState(State state) throws VisitorException {
        StateTransitionsDecorator std = new StateTransitionsDecorator(state);
        Iterator i = std.getHandledEvents().iterator();
        while (i.hasNext()) {
            Event event = (Event)i.next();
            if (std.getElseTransition(event) != null) continue;
            this.checkCompleteness(state, event, std.getAllNotElseTransitions(event));
        }
    }

    private void checkCompleteness(State state, Event event, List transitions) throws VisitorException {
        try {
            Guard residue;
            boolean everyGuardIsCompiled = true;
            Iterator i = transitions.iterator();
            while (i.hasNext()) {
                Transition transition = (Transition)i.next();
                if (transition.getGuard().getAST() != null) continue;
                everyGuardIsCompiled = false;
                break;
            }
            if (everyGuardIsCompiled && (residue = this.getResidue(transitions)) != null) {
                this.fireIncompleteGuardSet(this.sm, state, event, residue);
            }
        }
        catch (RecognitionException e) {
            throw new VisitorException(e);
        }
    }

    private Guard getResidue(List transitions) throws RecognitionException {
        HashSet<AST> guards = new HashSet<AST>();
        Iterator i = transitions.iterator();
        while (i.hasNext()) {
            Transition transition = (Transition)i.next();
            guards.add(transition.getGuard().getAST());
        }
        FormulaResolver disjunction = FormulaResolver.createDisjunction(guards);
        if (disjunction.isTautology()) {
            return null;
        }
        return this.sm.createGuard(disjunction.getSimplifiedDNF(false));
    }

    protected abstract void fireIncompleteGuardSet(StateMachine var1, State var2, Event var3, Guard var4);
}

