/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.transform.xml;

import com.evelopers.unimod.compilation.DefaultCompilationListener;
import com.evelopers.unimod.compilation.StateMachineCompiler;
import com.evelopers.unimod.core.stateworks.ClassElement;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.EventProviderHandler;
import com.evelopers.unimod.core.stateworks.Guard;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.StateType;
import com.evelopers.unimod.core.stateworks.Transition;
import com.evelopers.unimod.transform.TransformException;
import com.evelopers.unimod.transform.xml.XML;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLToModel
implements XML,
ErrorHandler {
    protected static final Log l;
    protected Map unresolvedMachines = new HashMap();
    protected Model model;
    protected StateMachine currentMachine = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.evelopers.unimod.transform.xml.XMLToModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        l = LogFactory.getLog((Class)clazz);
    }

    public static XMLToModel create() {
        return new XMLToModel();
    }

    protected XMLToModel() {
    }

    public Model transform(InputStream source) throws TransformException {
        return this.transform(source, null);
    }

    public Model transform(InputStream source, XMLReader xmlReader) throws TransformException {
        return this._transform(source, xmlReader);
    }

    protected Model _transform(InputStream xml) throws TransformException {
        return this._transform(xml, null);
    }

    protected Model _transform(InputStream xml, XMLReader xmlReader) throws TransformException {
        try {
            Digester digester = xmlReader != null ? new Digester(xmlReader) : new Digester();
            URL url = this.getClass().getClassLoader().getResource("com/evelopers/unimod/transform/xml/resources/statemachine.dtd");
            digester.register("-//eVelopers Corp.//DTD State machine model V1.0//EN", url.toString());
            digester.setValidating(true);
            digester.setErrorHandler((ErrorHandler)this);
            digester.addFactoryCreate("model", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) throws Exception {
                    String name = attributes.getValue("name");
                    XMLToModel.this.model = XMLToModel.this.createModel(name);
                    return XMLToModel.this.model;
                }
            });
            digester.addFactoryCreate("model/controlledObject", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) throws Exception {
                    String name = attributes.getValue("name");
                    String implClassName = attributes.getValue("class");
                    return XMLToModel.this.model.createControlledObjectHandler(name, implClassName);
                }
            });
            digester.addFactoryCreate("model/eventProvider", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) throws Exception {
                    String name = attributes.getValue("name");
                    String implClassName = attributes.getValue("class");
                    return XMLToModel.this.model.createEventProviderHandler(name, implClassName);
                }
            });
            digester.addFactoryCreate("model/eventProvider/association", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) throws Exception {
                    String clientRole = attributes.getValue("clientRole");
                    String targetRef = attributes.getValue("targetRef");
                    EventProviderHandler ep = (EventProviderHandler)this.getDigester().peek();
                    StateMachine machine = XMLToModel.this.resolveStateMachine(targetRef);
                    if (clientRole != null) {
                        return machine.createIncomingAssociation(ep, clientRole);
                    }
                    return machine.createIncomingAssociation(ep);
                }
            });
            digester.addFactoryCreate("model/rootStateMachine/stateMachineRef", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) throws Exception {
                    String name = attributes.getValue("name");
                    return XMLToModel.this.resolveStateMachine(name);
                }
            });
            digester.addSetNext("model/rootStateMachine/stateMachineRef", "setRootStateMachine");
            digester.addFactoryCreate("model/stateMachine", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) throws Exception {
                    String name = attributes.getValue("name");
                    XMLToModel.this.currentMachine = XMLToModel.this.createStateMachine(name);
                    return XMLToModel.this.currentMachine;
                }
            });
            digester.addFactoryCreate("model/stateMachine/configStore", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) throws Exception {
                    String className = attributes.getValue("class");
                    return className;
                }
            });
            digester.addSetNext("model/stateMachine/configStore", "setConfigManagerClassName");
            digester.addFactoryCreate("model/stateMachine/association", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) throws Exception {
                    String supplierRole = attributes.getValue("supplierRole");
                    String targetRef = attributes.getValue("targetRef");
                    StateMachine machine = (StateMachine)this.getDigester().peek();
                    ClassElement object = XMLToModel.this.resolveClassElement(targetRef);
                    if (object == null) {
                        throw new TransformException("Unresolved ref to class element: " + targetRef);
                    }
                    if (supplierRole != null) {
                        return machine.createOutgoingAssociation(object, supplierRole);
                    }
                    return machine.createOutgoingAssociation(object);
                }
            });
            digester.addFactoryCreate("model/stateMachine/state", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) throws Exception {
                    String name = attributes.getValue("name");
                    StateMachine stateMachine = (StateMachine)this.getDigester().peek();
                    State top = stateMachine.createTopState(name);
                    stateMachine.setTop(top);
                    return top;
                }
            });
            digester.addFactoryCreate("*/state/state", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) throws Exception {
                    String name = attributes.getValue("name");
                    StateType type = StateType.parseStateType(attributes.getValue("type"));
                    State superstate = (State)this.getDigester().peek();
                    State state = XMLToModel.this.currentMachine.createState(name, type);
                    state.setSuperstate(superstate);
                    return state;
                }
            });
            digester.addFactoryCreate("*/state/stateMachineRef", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) throws Exception {
                    String name = attributes.getValue("name");
                    return XMLToModel.this.resolveStateMachine(name);
                }
            });
            digester.addSetNext("*/state/stateMachineRef", "addSubmachine");
            digester.addFactoryCreate("*/state/outputAction", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) throws Exception {
                    String ident = attributes.getValue("ident");
                    return XMLToModel.this.currentMachine.createAction(ident);
                }
            });
            digester.addSetNext("*/state/outputAction", "addOnEnterAction");
            digester.addFactoryCreate("model/stateMachine/transition", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) throws Exception {
                    String eventName = attributes.getValue("event");
                    String expr = attributes.getValue("guard");
                    String name = attributes.getValue("name");
                    State source = XMLToModel.this.currentMachine.findState(attributes.getValue("sourceRef"));
                    State target = XMLToModel.this.currentMachine.findState(attributes.getValue("targetRef"));
                    Event event = eventName == null ? null : new Event(eventName);
                    Guard guard = XMLToModel.this.currentMachine.createGuard(expr);
                    Transition transition = XMLToModel.this.currentMachine.createTransition(source, target, guard, event);
                    transition.setName(name);
                    return transition;
                }
            });
            digester.addFactoryCreate("*/transition/outputAction", (ObjectCreationFactory)new AbstractObjectCreationFactory(){

                public Object createObject(Attributes attributes) throws Exception {
                    String ident = attributes.getValue("ident");
                    return XMLToModel.this.currentMachine.createAction(ident);
                }
            });
            digester.addSetNext("*/transition/outputAction", "addOutputAction");
            Model model = (Model)digester.parse(xml);
            if (!this.unresolvedMachines.isEmpty()) {
                throw new TransformException("There are unresolved state machine refs: " + this.getUnreslvedStateMachinesList());
            }
            return model;
        }
        catch (TransformException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransformException(e);
        }
    }

    private String getUnreslvedStateMachinesList() {
        StringBuffer s = new StringBuffer("");
        Iterator i = this.unresolvedMachines.keySet().iterator();
        while (i.hasNext()) {
            s.append(i.next()).append(" ");
        }
        return s.toString();
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    protected Model createModel(String name) {
        return Model.createModel(name);
    }

    protected ClassElement resolveClassElement(String name) {
        ClassElement ce = this.model.getControlledObjectHandler(name);
        if (ce == null) {
            ce = this.resolveStateMachine(name);
        }
        return ce;
    }

    protected StateMachine resolveStateMachine(String name) {
        StateMachine machine = this.model.getStateMachine(name);
        if (machine == null && (machine = (StateMachine)this.unresolvedMachines.get(name)) == null) {
            machine = this.model.createStateMachine(name);
            this.unresolvedMachines.put(machine.getName(), machine);
        }
        return machine;
    }

    protected StateMachine createStateMachine(String name) {
        StateMachine machine = (StateMachine)this.unresolvedMachines.get(name);
        if (machine != null) {
            this.unresolvedMachines.remove(machine.getName());
        } else {
            machine = this.model.createStateMachine(name);
        }
        return machine;
    }

    public static Model load(InputStream is) throws TransformException {
        return XMLToModel.load(is, null);
    }

    public static Model loadAndCompile(InputStream is, XMLReader xmlReader) throws IOException, TransformException {
        Model model = XMLToModel.load(is, xmlReader);
        StateMachineCompiler c = new StateMachineCompiler(null);
        DefaultCompilationListener cl = new DefaultCompilationListener();
        c.addCompilationListener(cl);
        Iterator i = model.getStateMachines().iterator();
        while (i.hasNext()) {
            c.compile((StateMachine)i.next());
        }
        String[] errors = cl.getErrors();
        if (errors.length > 0) {
            int i2 = 0;
            while (i2 < errors.length) {
                l.fatal((Object)errors[i2]);
                ++i2;
            }
            throw new TransformException("Model compilation error.");
        }
        return model;
    }

    public static Model loadAndCompile(InputStream is) throws IOException, TransformException {
        return XMLToModel.loadAndCompile(is, null);
    }

    public static Model load(InputStream is, XMLReader xmlReader) throws TransformException {
        XMLToModel x2m = XMLToModel.create();
        return x2m.transform(is, xmlReader);
    }
}

