/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.transform.xml;

import com.evelopers.unimod.transform.TransformException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLHelper {
    public static void save(Document d, OutputStream out, String publicId, String systemId) throws TransformException {
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("doctype-public", publicId);
            t.setOutputProperty("doctype-system", systemId);
            t.setOutputProperty("indent", "no");
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("version", "1.0");
            XMLHelper.addIndents(d);
            t.transform(new DOMSource(d), new StreamResult(out));
        }
        catch (Exception e) {
            throw new TransformException(e);
        }
    }

    public static void addIndents(Document document) {
        XMLHelper.formatTextNode(document.getLastChild());
        XMLHelper.indentNode(document.getLastChild(), 1);
    }

    public static void removeNullAttributes(Node node) {
        switch (node.getNodeType()) {
            case 9: {
                XMLHelper.removeNullAttributes(node.getLastChild());
                break;
            }
            case 1: {
                Element element = (Element)node;
                NamedNodeMap attributes = element.getAttributes();
                if (attributes != null) {
                    int i = 0;
                    while (i < attributes.getLength()) {
                        Node attribute = attributes.item(i);
                        if (attribute.getNodeValue() == null) {
                            element.removeAttribute(attribute.getNodeName());
                            --i;
                        }
                        ++i;
                    }
                }
                NodeList children = element.getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    XMLHelper.removeNullAttributes(children.item(i));
                    ++i;
                }
                break;
            }
        }
    }

    private static void indentNode(Node node, int level) {
        if (node.getNodeType() == 1 && node.getChildNodes().getLength() > 0) {
            StringBuffer buffer = new StringBuffer("\n");
            int i = 0;
            while (i < level - 1) {
                buffer.append("  ");
                ++i;
            }
            String endIndent = buffer.toString();
            buffer.append("  ");
            String childIndent = buffer.toString();
            NodeList children = node.getChildNodes();
            LinkedList<Node> l = new LinkedList<Node>();
            int i2 = 0;
            while (i2 < children.getLength()) {
                l.add(children.item(i2));
                ++i2;
            }
            Iterator i22 = l.iterator();
            while (i22.hasNext()) {
                Node child = (Node)i22.next();
                Text text = node.getOwnerDocument().createTextNode(childIndent);
                node.insertBefore(text, child);
            }
            Text text = node.getOwnerDocument().createTextNode(endIndent);
            node.appendChild(text);
            Iterator i3 = l.iterator();
            while (i3.hasNext()) {
                Node child = (Node)i3.next();
                XMLHelper.indentNode(child, level + 1);
            }
        }
    }

    private static void formatTextNode(Node node) {
        if (node.getNodeType() == 3) {
            String value = node.getNodeValue().trim();
            node.setNodeValue(value);
            if (value.length() <= 0) {
                node.getParentNode().removeChild(node);
                return;
            }
        }
        LinkedList<Node> list = new LinkedList<Node>();
        int i = 0;
        while (i < node.getChildNodes().getLength()) {
            list.add(node.getChildNodes().item(i));
            ++i;
        }
        Iterator i2 = list.iterator();
        while (i2.hasNext()) {
            Node node1 = (Node)i2.next();
            XMLHelper.formatTextNode(node1);
        }
    }
}

