/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.transform.xml;

import com.evelopers.common.util.helper.StringHelper;
import com.evelopers.unimod.core.stateworks.Action;
import com.evelopers.unimod.core.stateworks.Association;
import com.evelopers.unimod.core.stateworks.ControlledObjectHandler;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.EventProviderHandler;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.Transition;
import com.evelopers.unimod.resources.Messages;
import com.evelopers.unimod.transform.TransformException;
import com.evelopers.unimod.transform.xml.XML;
import com.evelopers.unimod.transform.xml.XMLHelper;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class ModelToXML
implements XML {
    private Document document = null;
    private static ModelToXML instance = null;

    private ModelToXML() {
    }

    public static synchronized ModelToXML create() {
        if (instance == null) {
            instance = new ModelToXML();
        }
        return instance;
    }

    public static void write(Model model, OutputStream out) throws TransformException {
        ModelToXML.create();
        Document document = instance._transform(model);
        XMLHelper.save(document, out, "-//eVelopers Corp.//DTD State machine model V1.0//EN", "http://www.evelopers.com/dtd/unimod/statemachine.dtd");
    }

    public Document transform(Model source) throws TransformException {
        return this._transform(source);
    }

    private Document _transform(Model model) throws TransformException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImpl = builder.newDocument().getImplementation();
            DocumentType doctype = domImpl.createDocumentType("model", "-//eVelopers Corp.//DTD State machine model V1.0//EN", "http://www.evelopers.com/dtd/unimod/statemachine.dtd");
            this.document = domImpl.createDocument("", "model", doctype);
        }
        catch (Exception e) {
            throw new TransformException(e.getMessage());
        }
        try {
            this.createModelNode(this.document.getDocumentElement(), model);
        }
        catch (Exception e) {
            throw new TransformException(Messages.getMessages().getMessage("E11", new Object[]{e.getMessage(), StringHelper.stackTraceToString((Throwable)e)}));
        }
        return this.document;
    }

    private void createModelNode(Element e, Model model) throws Exception {
        e.setAttribute("name", model.getName());
        Iterator iter = model.getControlledObjectHandlers().iterator();
        while (iter.hasNext()) {
            e.appendChild(this.createControlledObjectNode((ControlledObjectHandler)iter.next()));
        }
        Iterator i = model.getEventProviderHandlers().iterator();
        while (i.hasNext()) {
            EventProviderHandler ep = (EventProviderHandler)i.next();
            e.appendChild(this.createEventProviderNode(ep));
        }
        e.appendChild(this.createRootStateMachineNode(model.getRootStateMachine()));
        iter = model.getStateMachines().iterator();
        while (iter.hasNext()) {
            e.appendChild(this.createStateMachineNode((StateMachine)iter.next()));
        }
    }

    private Element createControlledObjectNode(ControlledObjectHandler co) throws Exception {
        Element e = this.document.createElement("controlledObject");
        e.setAttribute("name", co.getName());
        e.setAttribute("class", co.getImplName());
        return e;
    }

    private Element createEventProviderNode(EventProviderHandler ep) throws Exception {
        Element e = this.document.createElement("eventProvider");
        if (ep.getName() != null) {
            e.setAttribute("name", ep.getName());
        }
        e.setAttribute("class", ep.getImplName());
        Iterator i = ep.getOutgoingAssociations().iterator();
        while (i.hasNext()) {
            Association association = (Association)i.next();
            e.appendChild(this.createAssociationNode(association));
        }
        return e;
    }

    private Element createRootStateMachineNode(StateMachine stateMachine) throws Exception {
        Element e = this.document.createElement("rootStateMachine");
        e.appendChild(this.createStateMachineRefNode(stateMachine));
        return e;
    }

    private Element createStateMachineRefNode(StateMachine sm) {
        Element e = this.document.createElement("stateMachineRef");
        e.setAttribute("name", sm.getName());
        return e;
    }

    private Element createStateMachineNode(StateMachine sm) throws Exception {
        Element e = this.document.createElement("stateMachine");
        e.setAttribute("name", sm.getName());
        if (sm.getConfigManagerClassName() != null) {
            e.appendChild(this.createConfigManagerNode(sm.getConfigManagerClassName()));
        }
        Iterator i = sm.getOutgoingAssociations().iterator();
        while (i.hasNext()) {
            Association association = (Association)i.next();
            e.appendChild(this.createAssociationNode(association));
        }
        e.appendChild(this.createStateNode(sm.getTop()));
        i = sm.getAllTransition().iterator();
        while (i.hasNext()) {
            e.appendChild(this.createTransitionNode((Transition)i.next()));
        }
        return e;
    }

    private Element createConfigManagerNode(String cs) throws Exception {
        Element e = this.document.createElement("configStore");
        e.setAttribute("class", cs);
        return e;
    }

    private Element createAssociationNode(Association a) throws Exception {
        Element e = this.document.createElement("association");
        e.setAttribute("targetRef", a.getTarget().getName());
        if (a.getClientRole() != null) {
            e.setAttribute("clientRole", a.getClientRole());
        }
        if (a.getSupplierRole() != null) {
            e.setAttribute("supplierRole", a.getSupplierRole());
        }
        return e;
    }

    private Element createStateNode(State s) throws Exception {
        Element e = this.document.createElement("state");
        e.setAttribute("name", s.getName());
        e.setAttribute("type", String.valueOf(s.getType()));
        Iterator i = s.getSubstates().iterator();
        while (i.hasNext()) {
            State substate = (State)i.next();
            e.appendChild(this.createStateNode(substate));
        }
        i = s.getSubmachines().iterator();
        while (i.hasNext()) {
            StateMachine subMachine = (StateMachine)i.next();
            e.appendChild(this.createStateMachineRefNode(subMachine));
        }
        i = s.getOnEnterActions().iterator();
        while (i.hasNext()) {
            Action action = (Action)i.next();
            e.appendChild(this.createOutputActionNode(action));
        }
        return e;
    }

    private Element createOutputActionNode(Action o) {
        Element e = this.document.createElement("outputAction");
        e.setAttribute("ident", o.getIdentifier());
        return e;
    }

    private Element createTransitionNode(Transition t) throws Exception {
        Element e = this.document.createElement("transition");
        if (t.getName() != null) {
            e.setAttribute("name", t.getName());
        }
        e.setAttribute("sourceRef", t.getSourceState().getName());
        e.setAttribute("targetRef", t.getTargetState().getName());
        if (t.getEvent() != null && !t.getEvent().equals(Event.NO_EVENT)) {
            e.setAttribute("event", t.getEvent().getName());
        }
        boolean tautology = "true".equalsIgnoreCase(t.getGuard().getExpr());
        if (t.getGuard() != null && !tautology) {
            e.setAttribute("guard", t.getGuard().getExpr());
        }
        Iterator i = t.getOutputActions().iterator();
        while (i.hasNext()) {
            Action action = (Action)i.next();
            e.appendChild(this.createOutputActionNode(action));
        }
        return e;
    }
}

