/*
 * Decompiled with CFR 0.152.
 */
package com.evelopers.unimod.transform.source;

import com.evelopers.unimod.core.stateworks.Action;
import com.evelopers.unimod.core.stateworks.ClassElement;
import com.evelopers.unimod.core.stateworks.ControlledObjectHandler;
import com.evelopers.unimod.core.stateworks.Event;
import com.evelopers.unimod.core.stateworks.EventProviderHandler;
import com.evelopers.unimod.core.stateworks.Model;
import com.evelopers.unimod.core.stateworks.State;
import com.evelopers.unimod.core.stateworks.StateMachine;
import com.evelopers.unimod.core.stateworks.Transition;
import com.evelopers.unimod.parser.ActionCollector;
import com.evelopers.unimod.parser.IdentNode;
import com.evelopers.unimod.parser.Infix;
import com.evelopers.unimod.parser.InterpreterException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class Tool {
    private final char[] REPLACE_SYMBOLS = new char[]{' ', '.', '/', '\\', '\'', '\"'};

    private Tool() {
    }

    public static Tool create() {
        return new Tool();
    }

    public String toJavaIdent(String s) {
        int i = 0;
        while (i < this.REPLACE_SYMBOLS.length) {
            s = s.replace(this.REPLACE_SYMBOLS[i], '_');
            ++i;
        }
        if (s.charAt(0) >= '0' && s.charAt(0) <= '9') {
            s = "_" + s;
        }
        return s;
    }

    public String actionIdentToLocalVar(String s) {
        s = s.replace('.', '_');
        return s;
    }

    public Set getAllEvents(StateMachine sm) {
        HashSet e = new HashSet();
        Iterator i = sm.getAllStates().iterator();
        while (i.hasNext()) {
            State s = (State)i.next();
            e.addAll(s.getEvents(false));
        }
        e.remove(Event.NO_EVENT);
        return e;
    }

    public boolean handlesEvent(State state, Event event) {
        State cur = state;
        while (cur != null) {
            List transitions = cur.getFilteredOutgoingTransitions(event, false);
            transitions.addAll(state.getFilteredOutgoingTransitions(event, true));
            if (!transitions.isEmpty()) {
                return true;
            }
            cur = cur.getSuperstate();
        }
        return false;
    }

    public Set getHandledEventsWithSuperstates(State state) {
        HashSet e = new HashSet();
        State cur = state;
        while (cur != null) {
            e.addAll(cur.getEvents(false));
            cur = cur.getSuperstate();
        }
        return e;
    }

    public Set getInputActions(StateMachine sm, Class returnType) throws InterpreterException {
        HashSet<Action> in = new HashSet<Action>();
        Iterator i = sm.getAllTransition().iterator();
        while (i.hasNext()) {
            Transition t = (Transition)i.next();
            String g = Infix.infix(t.getGuard().getAST());
            if (g.equals("false") || g.equals("true") || g.equals("else")) continue;
            Iterator j = ActionCollector.collectIdentNodes(t.getGuard().getAST()).iterator();
            while (j.hasNext()) {
                IdentNode id = (IdentNode)((Object)j.next());
                if (!id.getReturnType().equals(returnType)) continue;
                in.add(id.getAction());
            }
        }
        return in;
    }

    public List getNonSMClassElements(Model model) {
        HashSet<String> addedClassElements = new HashSet<String>();
        ArrayList<ClassElement> nonSMClassElements = new ArrayList<ClassElement>();
        List coHandlers = model.getControlledObjectHandlers();
        Iterator i = coHandlers.iterator();
        while (i.hasNext()) {
            ControlledObjectHandler coHandler = (ControlledObjectHandler)i.next();
            if (!StringUtils.isNotBlank((String)coHandler.getName()) || addedClassElements.contains(coHandler.getName())) continue;
            nonSMClassElements.add(coHandler);
            addedClassElements.add(coHandler.getName());
        }
        List epHandlers = model.getEventProviderHandlers();
        Iterator i2 = epHandlers.iterator();
        while (i2.hasNext()) {
            EventProviderHandler epHandler = (EventProviderHandler)i2.next();
            if (!StringUtils.isNotBlank((String)epHandler.getName()) || addedClassElements.contains(epHandler.getName())) continue;
            nonSMClassElements.add(epHandler);
            addedClassElements.add(epHandler.getName());
        }
        return nonSMClassElements;
    }

    public boolean hasName(ClassElement classElement) {
        return classElement != null && StringUtils.isNotBlank((String)classElement.getName());
    }
}

